/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.gpg;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.gpg.AbstractGpgMojoExtension;
import org.apache.maven.plugins.gpg.ProxySignerWithPublicKeyAccess;
import org.apache.maven.project.MavenProject;
import org.bouncycastle.openpgp.PGPSignature;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.xz.XZArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.gpg.KeyStore;
import org.eclipse.tycho.gpg.SignatureStore;
import org.eclipse.tycho.p2maven.repository.P2RepositoryManager;

@Mojo(name="sign-p2-artifacts", requiresProject=true, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class SignRepositoryArtifactsMojo
extends AbstractGpgMojoExtension {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/repository")
    private File repository;
    @Parameter(defaultValue="true")
    private boolean skipIfJarsigned;
    @Parameter(defaultValue="true")
    private boolean skipIfJarsignedAndAnchored;
    @Parameter(defaultValue="true")
    boolean skipBinaries;
    @Parameter(defaultValue="true")
    private boolean addPublicKeyToRepo;
    @Parameter(defaultValue="true", alias="addPublicKeysToArtifacts")
    private boolean addPublicKeyToArtifacts;
    @Parameter(defaultValue="skip")
    private PGPKeyBehavior pgpKeyBehavior;
    @Parameter(property="tycho.pgp.signer", defaultValue="gpg")
    private String signer;
    @Parameter(property="tycho.pgp.signer.bc.secretKeys")
    private File secretKeys;
    @Parameter
    private List<String> forceSignature;
    @Component(role=UnArchiver.class, hint="zip")
    private ZipUnArchiver zipUnArchiver;
    @Component(role=Archiver.class, hint="xz")
    private XZArchiver xzArchiver;
    @Component
    private SignedContentFactory signedContentFactory;
    @Component
    private P2RepositoryManager repositoryManager;

    @Override
    protected String getSigner() {
        return this.signer;
    }

    @Override
    protected File getPGPInfo() {
        String pgpInfo = System.getProperty("org.eclipse.tycho.test.pgp.info");
        return pgpInfo == null ? null : new File(pgpInfo);
    }

    @Override
    protected File getSecretKeys() {
        return this.secretKeys;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProxySignerWithPublicKeyAccess signer = this.newSigner(this.project);
        KeyStore keys = KeyStore.create(new String[0]);
        try {
            String repositoryKeys;
            IFileArtifactRepository artifactRepository = (IFileArtifactRepository)this.repositoryManager.getArtifactRepository(new MavenRepositoryLocation("", this.repository.toURI()));
            boolean compressed = "true".equals(artifactRepository.getProperty("p2.compressed"));
            if (this.addPublicKeyToRepo && this.pgpKeyBehavior != PGPKeyBehavior.replace && (repositoryKeys = artifactRepository.getProperty("pgp.publicKeys")) != null) {
                keys.add(repositoryKeys);
            }
            IQueryResult artifactKeys = artifactRepository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
            List descriptors = artifactKeys.stream().map(arg_0 -> ((IFileArtifactRepository)artifactRepository).getArtifactDescriptors(arg_0)).flatMap(Arrays::stream).toList();
            descriptors.parallelStream().forEach(it -> this.handle((IArtifactDescriptor)it, artifactRepository.getArtifactFile(it), signer, keys));
            if (this.addPublicKeyToRepo && !keys.isEmpty()) {
                artifactRepository.setProperty("pgp.publicKeys", keys.toArmoredString());
            }
            ((SimpleArtifactRepository)artifactRepository).save();
            File artifactsXml = new File(this.repository, "artifacts.xml");
            File artifactsXmlXz = new File(this.repository, "artifacts.xml.xz");
            File artifactsJar = new File(this.repository, "artifacts.jar");
            if (!artifactsXml.exists() && artifactsJar.exists()) {
                this.zipUnArchiver.setSourceFile(artifactsJar);
                this.zipUnArchiver.setDestDirectory(this.repository);
                this.zipUnArchiver.extract();
            }
            this.xzArchiver.setDestFile(artifactsXmlXz);
            this.xzArchiver.addFile(artifactsXml, artifactsXml.getName());
            this.xzArchiver.createArchive();
            if (compressed) {
                artifactsXml.delete();
            }
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MojoExecutionException) {
                throw (MojoExecutionException)cause;
            }
            if (cause instanceof MojoFailureException) {
                throw (MojoFailureException)cause;
            }
            throw e;
        }
        catch (IOException | ProvisionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void handle(IArtifactDescriptor artifactDescriptor, File artifact, ProxySignerWithPublicKeyAccess signer, KeyStore allKeys) {
        if (artifact != null) {
            String existingKeys = artifactDescriptor.getProperty("pgp.publicKeys");
            String existingSignatures = artifactDescriptor.getProperty("pgp.signatures");
            if (existingSignatures != null && this.pgpKeyBehavior == PGPKeyBehavior.skip) {
                return;
            }
            IArtifactKey artifactKey = artifactDescriptor.getArtifactKey();
            if (this.forceSignature == null || !this.forceSignature.contains(artifactKey.getId())) {
                String classifier = artifactKey.getClassifier();
                boolean isBinary = "binary".equals(classifier);
                if (this.skipBinaries && isBinary) {
                    return;
                }
                if (!isBinary) {
                    try {
                        SignedContent signedContent = this.signedContentFactory.getSignedContent(artifact);
                        if (signedContent.isSigned()) {
                            for (SignerInfo signerInfo : signedContent.getSignerInfos()) {
                                signedContent.checkValidity(signerInfo);
                            }
                            if (this.skipIfJarsigned) {
                                return;
                            }
                            if (this.skipIfJarsignedAndAnchored) {
                                for (SignerInfo signerInfo : signedContent.getSignerInfos()) {
                                    if (signerInfo.getTrustAnchor() == null) continue;
                                    return;
                                }
                            }
                        }
                    }
                    catch (Exception signedContent) {
                        // empty catch block
                    }
                }
            }
            if (this.pgpKeyBehavior == PGPKeyBehavior.replace) {
                existingSignatures = null;
                existingKeys = null;
            }
            try {
                SignatureStore signatures = signer.generateSignature(artifact);
                List signerKeys = signatures.all().stream().map(PGPSignature::getKeyID).flatMap(id -> signer.getPublicKeys().getKeys((long)id).stream()).toList();
                KeyStore keyStore = KeyStore.create(existingKeys);
                keyStore.add(signerKeys);
                allKeys.add(keyStore);
                signatures.add(existingSignatures);
                ((ArtifactDescriptor)artifactDescriptor).setProperty("pgp.signatures", signatures.toArmoredString());
                if (this.addPublicKeyToArtifacts) {
                    ((ArtifactDescriptor)artifactDescriptor).setProperty("pgp.publicKeys", keyStore.toArmoredString());
                }
            }
            catch (IOException | MojoExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    static enum PGPKeyBehavior {
        skip,
        replace,
        merge;

    }
}

