/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.gpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;

public class SignatureStore {
    private final Map<String, PGPSignature> signatures = new TreeMap<String, PGPSignature>();

    public static SignatureStore create(String ... signatures) {
        SignatureStore store = new SignatureStore();
        store.add(signatures);
        return store;
    }

    public static SignatureStore create(PGPSignature ... signatures) {
        SignatureStore store = new SignatureStore();
        for (PGPSignature signature : signatures) {
            store.add(signature);
        }
        return store;
    }

    private SignatureStore() {
    }

    public Collection<? extends PGPSignature> all() {
        return this.signatures.values();
    }

    public void add(PGPSignature signature) {
        try {
            this.signatures.put(PGPPublicKeyService.toHex((byte[])signature.getEncoded()), signature);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void add(String ... signatures) {
        for (String signature : signatures) {
            if (signature == null) continue;
            this.readSignatures(signature);
        }
    }

    public String toArmoredString() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ArmoredOutputStream armoredOut = new ArmoredOutputStream((OutputStream)out);){
            armoredOut.setHeader("Version", null);
            for (PGPSignature signatures : this.signatures.values()) {
                signatures.encode((OutputStream)armoredOut);
            }
        }
        return out.toString(StandardCharsets.US_ASCII);
    }

    private void readSignatures(String signature) {
        try (ArmoredInputStream in = new ArmoredInputStream((InputStream)new ByteArrayInputStream(signature.getBytes(StandardCharsets.US_ASCII)));){
            BcPGPObjectFactory factory = new BcPGPObjectFactory((InputStream)in);
            for (Object object : factory) {
                this.collectSignatures(object);
            }
        }
        catch (IOException | PGPException e) {
            throw new RuntimeException(e);
        }
    }

    private void collectSignatures(Object object) throws PGPException, IOException {
        block3: {
            block2: {
                if (!(object instanceof PGPCompressedData)) break block2;
                PGPCompressedData pgpCompressData = (PGPCompressedData)object;
                for (Object data : new BcPGPObjectFactory(pgpCompressData.getDataStream())) {
                    this.collectSignatures(data);
                }
                break block3;
            }
            if (!(object instanceof PGPSignatureList)) break block3;
            PGPSignatureList signatureList = (PGPSignatureList)object;
            for (PGPSignature signature : signatureList) {
                this.signatures.put(PGPPublicKeyService.toHex((byte[])signature.getEncoded()), signature);
            }
        }
    }
}

