/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model;

import aQute.bnd.version.VersionRange;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.FeatureResourceBuilder;
import org.eclipse.tycho.model.PluginRef;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;

public class Feature {
    public static final String MATCH_GREATER_OR_EQUAL = "greaterOrEqual";
    public static final String MATCH_COMPATIBLE = "compatible";
    public static final String MATCH_EQUIVALENT = "equivalent";
    public static final String MATCH_PERFECT = "perfect";
    public static final String FEATURE_XML = "feature.xml";
    private static XMLParser parser = new XMLParser();
    private final Document document;
    private final Element dom;
    private ArrayList<PluginRef> plugins;
    private ArrayList<FeatureRef> features;
    private File source;

    public Feature(Document document) {
        this.document = document;
        this.dom = document.getRootElement();
    }

    public Feature(Feature other) {
        this(other.document.copy());
    }

    public List<PluginRef> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
            for (Element pluginDom : this.dom.getChildren("plugin")) {
                this.plugins.add(new PluginRef(pluginDom));
            }
        }
        return Collections.unmodifiableList(this.plugins);
    }

    public void setVersion(String version) {
        this.dom.setAttribute("version", version);
    }

    public List<FeatureRef> getIncludedFeatures() {
        if (this.features == null) {
            this.features = new ArrayList();
            for (Element featureDom : this.dom.getChildren("includes")) {
                this.features.add(new FeatureRef(featureDom));
            }
        }
        return Collections.unmodifiableList(this.features);
    }

    public List<RequiresRef> getRequires() {
        ArrayList<RequiresRef> requires = new ArrayList<RequiresRef>();
        for (Element requiresDom : this.dom.getChildren("requires")) {
            requires.add(new RequiresRef(requiresDom));
        }
        return Collections.unmodifiableList(requires);
    }

    public String getVersion() {
        return this.dom.getAttributeValue("version");
    }

    public String getId() {
        return this.dom.getAttributeValue("id");
    }

    public void setId(String id) {
        this.dom.setAttribute("id", id);
    }

    public String getBrandingPluginId() {
        return this.dom.getAttributeValue("plugin");
    }

    public void setBrandingPluginId(String id) {
        this.dom.setAttribute("plugin", id);
    }

    public String getLicenseFeature() {
        return this.dom.getAttributeValue("license-feature");
    }

    public void setLicenseFeature(String featureId) {
        if (featureId != null) {
            this.dom.setAttribute("license-feature", featureId);
        } else {
            this.dom.removeAttribute("license-feature");
        }
    }

    public String getLicenseFeatureVersion() {
        return this.dom.getAttributeValue("license-feature-version");
    }

    public void setLicenseFeatureVersion(String version) {
        if (version != null) {
            this.dom.setAttribute("license-feature-version", version);
        } else {
            this.dom.removeAttribute("license-feature-version");
        }
    }

    public static Feature read(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        return Feature.read(is);
    }

    public static Feature read(InputStream input) throws IOException {
        try (InputStream inputStream = input;){
            Feature feature = new Feature(parser.parse((XMLSource)new XMLIOSource(input)));
            return feature;
        }
    }

    public static void write(Feature feature, File file) throws IOException {
        Feature.write(feature, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Feature feature, File file, String indent) throws IOException {
        Document document = feature.document;
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            String enc = document.getEncoding() != null ? document.getEncoding() : "UTF-8";
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, enc);
            XMLWriter xw = new XMLWriter((Writer)w);
            xw.setIndent(indent);
            try {
                document.toXML(xw);
            }
            finally {
                xw.flush();
            }
        }
    }

    public static Feature readJar(File file) throws IOException {
        try (JarFile jar = new JarFile(file);){
            ZipEntry ze = jar.getEntry(FEATURE_XML);
            if (ze != null) {
                InputStream is = jar.getInputStream(ze);
                Feature read = Feature.read(is);
                read.source = file;
                Feature feature = read;
                return feature;
            }
            throw new IOException(file.getAbsolutePath() + " does not have feature.xml entry.");
        }
    }

    public static Feature loadFeature(File location) {
        try {
            Feature feature = location.isDirectory() ? Feature.read(new File(location, FEATURE_XML)) : Feature.readJar(location);
            return feature;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read feature descriptor at " + location.getAbsolutePath(), e);
        }
    }

    public void addPlugin(PluginRef plugin) {
        this.dom.addNode((Node)plugin.getDom());
        this.plugins = null;
    }

    public void addFeatureRef(FeatureRef feature) {
        this.dom.addNode((Node)feature.getDom());
        this.features = null;
    }

    public String getLabel() {
        return this.dom.getAttributeValue("label");
    }

    public void setLabel(String label) {
        this.dom.setAttribute("label", label);
    }

    public String getProvider() {
        return this.dom.getAttributeValue("provider-name");
    }

    public void setProvider(String provider) {
        this.dom.setAttribute("provider-name", provider);
    }

    public String getDescription() {
        Element descElement = this.dom.getChild("description");
        if (descElement != null) {
            return descElement.getText();
        }
        return null;
    }

    public void setDescription(String description) {
        Element descElement = this.dom.getChild("description");
        if (descElement == null) {
            descElement = new Element("description");
            this.dom.addNode((Node)descElement);
        }
        descElement.setText(description);
    }

    public String getDescriptionURL() {
        Element descElement = this.dom.getChild("description");
        if (descElement != null) {
            return descElement.getAttributeValue("url");
        }
        return null;
    }

    public void setDescriptionURL(String descriptionURL) {
        Element descElement = this.dom.getChild("description");
        if (descElement == null) {
            descElement = new Element("description");
            this.dom.addNode((Node)descElement);
        }
        descElement.setAttribute("url", descriptionURL);
    }

    public String getCopyright() {
        Element copyrightElement = this.dom.getChild("copyright");
        if (copyrightElement != null) {
            return copyrightElement.getText();
        }
        return null;
    }

    public void setCopyright(String description) {
        Element copyrightElement = this.dom.getChild("copyright");
        if (copyrightElement == null) {
            copyrightElement = new Element("copyright");
            this.dom.addNode((Node)copyrightElement);
        }
        copyrightElement.setText(description);
    }

    public String getCopyrightURL() {
        Element copyrightElement = this.dom.getChild("copyright");
        if (copyrightElement != null) {
            return copyrightElement.getAttributeValue("url");
        }
        return null;
    }

    public void setCopyrightURL(String copyrightURL) {
        Element copyrightElement = this.dom.getChild("copyright");
        if (copyrightElement == null) {
            copyrightElement = new Element("copyright");
            this.dom.addNode((Node)copyrightElement);
        }
        copyrightElement.setAttribute("url", copyrightURL);
    }

    public String getLicense() {
        Element licenseElement = this.dom.getChild("license");
        if (licenseElement != null) {
            return licenseElement.getText();
        }
        return null;
    }

    public void setLicense(String license) {
        Element licenseElement = this.dom.getChild("license");
        if (licenseElement == null) {
            licenseElement = new Element("license");
            this.dom.addNode((Node)licenseElement);
        }
        licenseElement.setText(license);
    }

    public String getLicenseURL() {
        Element licenseElement = this.dom.getChild("license");
        if (licenseElement != null) {
            return licenseElement.getAttributeValue("url");
        }
        return null;
    }

    public void setLicenseURL(String licenseURL) {
        Element licenseElement = this.dom.getChild("license");
        if (licenseElement == null) {
            licenseElement = new Element("license");
            this.dom.addNode((Node)licenseElement);
        }
        licenseElement.setAttribute("url", licenseURL);
    }

    public String getOS() {
        return this.dom.getAttributeValue("os");
    }

    public void setOS(String value) {
        this.dom.setAttribute("os", value);
    }

    public String getArch() {
        return this.dom.getAttributeValue("arch");
    }

    public void setArch(String value) {
        this.dom.setAttribute("arch", value);
    }

    public String getWS() {
        return this.dom.getAttributeValue("ws");
    }

    public void setWS(String value) {
        this.dom.setAttribute("ws", value);
    }

    public Stream<Resource> toResource() {
        return Stream.of(this.toJarResource(), this.toGroupResource());
    }

    public Resource toGroupResource() {
        FeatureResourceBuilder featureGroup = new FeatureResourceBuilder();
        featureGroup.addFeatureGroupCapability(this.getId(), this.getVersion());
        featureGroup.addFeatureJarRequirement(this.getId(), this.getVersion());
        for (PluginRef pluginRef : this.getPlugins()) {
            featureGroup.addRequireBundle(pluginRef.getId(), new VersionRange("[" + pluginRef.getVersion() + "," + pluginRef.getVersion() + "]"));
        }
        for (FeatureRef featureRef : this.getIncludedFeatures()) {
            featureGroup.addRequireFeature(featureRef.getId(), "[" + featureRef.getVersion() + "," + featureRef.getVersion() + "]");
        }
        for (RequiresRef requiresRef : this.getRequires()) {
            for (ImportRef importRef : requiresRef.getImports()) {
                String feature = importRef.getFeature();
                String plugin = importRef.getPlugin();
                VersionRange range = Feature.getVersionRange(importRef);
                if (feature != null && !this.features.isEmpty()) {
                    featureGroup.addRuntimeFeature(feature, range);
                    continue;
                }
                if (plugin == null || plugin.isEmpty()) continue;
                featureGroup.addRuntimeBundleRequirement(plugin, range);
            }
        }
        return featureGroup.build();
    }

    private static VersionRange getVersionRange(ImportRef importRef) {
        String version = importRef.getVersion();
        if (version == null || version.isEmpty()) {
            return new VersionRange(Version.emptyVersion.toString());
        }
        Version parsed = Version.parseVersion((String)version);
        String match = importRef.getMatch();
        if (MATCH_PERFECT.equals(match)) {
            return new VersionRange("[" + parsed + "," + parsed + "]");
        }
        if (MATCH_EQUIVALENT.equals(match)) {
            return new VersionRange("[" + parsed + "," + parsed.getMajor() + "." + parsed.getMinor() + "1)");
        }
        if (MATCH_COMPATIBLE.equals(match)) {
            return new VersionRange("[" + parsed + "," + (parsed.getMajor() + 1) + ")");
        }
        if (MATCH_GREATER_OR_EQUAL.equals(match)) {
            return new VersionRange(version);
        }
        throw new IllegalArgumentException("Can't parse value of match = " + match);
    }

    public Resource toJarResource() {
        FeatureResourceBuilder featureJar = new FeatureResourceBuilder();
        featureJar.addFeatureJarCapability(this.getId(), this.getVersion());
        if (this.source != null) {
            String sha256;
            try (FileInputStream data = new FileInputStream(this.source);){
                sha256 = DigestUtils.sha256Hex((InputStream)data);
            }
            catch (IOException e) {
                throw new RuntimeException("Computing digest failed!", e);
            }
            featureJar.addContentCapability(this.source.toURI(), sha256, this.source.length(), "application/eclipse-feature");
        }
        return featureJar.build();
    }

    public static class RequiresRef {
        private final Element dom;

        public RequiresRef(Element dom) {
            this.dom = dom;
        }

        public List<ImportRef> getImports() {
            ArrayList<ImportRef> imports = new ArrayList<ImportRef>();
            for (Element importsDom : this.dom.getChildren("import")) {
                imports.add(new ImportRef(importsDom));
            }
            return Collections.unmodifiableList(imports);
        }
    }

    public static class ImportRef {
        private final Element dom;

        public ImportRef(Element dom) {
            this.dom = dom;
        }

        public String getPlugin() {
            return this.dom.getAttributeValue("plugin");
        }

        public String getFeature() {
            return this.dom.getAttributeValue("feature");
        }

        public String getVersion() {
            return this.dom.getAttributeValue("version");
        }

        public void setVersion(String version) {
            this.dom.setAttribute("version", version);
        }

        public String getMatch() {
            String match = this.dom.getAttributeValue("match");
            if (match == null || match.isBlank()) {
                return Feature.MATCH_COMPATIBLE;
            }
            return match;
        }

        public void setMatch(String match) {
            this.dom.setAttribute("match", match);
        }

        public String getPatch() {
            String patch = this.dom.getAttributeValue("patch");
            if (patch == null) {
                return "false";
            }
            return patch;
        }

        public String toString() {
            String patch;
            String match;
            String version;
            String feature;
            StringBuilder builder = new StringBuilder();
            builder.append("ImportRef [");
            String plugin = this.getPlugin();
            if (plugin != null) {
                builder.append("plugin=");
                builder.append(plugin);
                builder.append(", ");
            }
            if ((feature = this.getFeature()) != null) {
                builder.append("Feature=");
                builder.append(feature);
                builder.append(", ");
            }
            if ((version = this.getVersion()) != null) {
                builder.append("version=");
                builder.append(version);
                builder.append(", ");
            }
            if ((match = this.getMatch()) != null) {
                builder.append("match=");
                builder.append(match);
                builder.append(", ");
            }
            if ((patch = this.getPatch()) != null) {
                builder.append("patch=");
                builder.append(patch);
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

