/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model;

import de.pdark.decentxml.Element;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Launcher {
    public static final String ICON_LINUX = "icon";
    public static final String ICON_MAC = "icon";
    public static final String ICON_FREEBSD = "icon";
    public static final String ICON_WINDOWS_ICO_PATH = "path";
    public static final String ICON_WINDOWS_EXTRA_LARGE_HIGH = "winExtraLargeHigh";
    public static final String ICON_WINDOWS_LARGE_LOW = "winLargeLow";
    public static final String ICON_WINDOWS_LARGE_HIGH = "winLargeHigh";
    public static final String ICON_WINDOWS_MEDIUM_LOW = "winMediumLow";
    public static final String ICON_WINDOWS_MEDIUM_HIGH = "winMediumHigh";
    public static final String ICON_WINDOWS_SMALL_LOW = "winSmallLow";
    public static final String ICON_WINDOWS_SMALL_HIGH = "winSmallHigh";
    public static final String ICON_SOLARIS_TINY = "solarisTiny";
    public static final String ICON_SOLARIS_SMALL = "solarisSmall";
    public static final String ICON_SOLARIS_MEDIUM = "solarisMedium";
    public static final String ICON_SOLARIS_LARGE = "solarisLarge";
    private Element dom;

    public Launcher(Element domLauncher) {
        this.dom = domLauncher;
    }

    public String getName() {
        return this.dom.getAttributeValue("name");
    }

    public Map<String, String> getLinuxIcon() {
        Element linuxDom = this.dom.getChild("linux");
        if (linuxDom == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> linux = new HashMap<String, String>();
        this.putIfNotNull(linux, "icon", linuxDom.getAttributeValue("icon"));
        return Collections.unmodifiableMap(linux);
    }

    public Map<String, String> getFreeBSDIcon() {
        Element freebsdDom = this.dom.getChild("freebsd");
        if (freebsdDom == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> freebsd = new HashMap<String, String>(1);
        this.putIfNotNull(freebsd, "icon", freebsdDom.getAttributeValue("icon"));
        return Collections.unmodifiableMap(freebsd);
    }

    public Map<String, String> getMacosxIcon() {
        Element macosxDom = this.dom.getChild("macosx");
        if (macosxDom == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> mac = new HashMap<String, String>();
        this.putIfNotNull(mac, "icon", macosxDom.getAttributeValue("icon"));
        return Collections.unmodifiableMap(mac);
    }

    public Map<String, String> getSolarisIcon() {
        Element solarisDom = this.dom.getChild("solaris");
        if (solarisDom == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> solaris = new HashMap<String, String>();
        this.putIfNotNull(solaris, ICON_SOLARIS_LARGE, solarisDom.getAttributeValue(ICON_SOLARIS_LARGE));
        this.putIfNotNull(solaris, ICON_SOLARIS_MEDIUM, solarisDom.getAttributeValue(ICON_SOLARIS_MEDIUM));
        this.putIfNotNull(solaris, ICON_SOLARIS_SMALL, solarisDom.getAttributeValue(ICON_SOLARIS_SMALL));
        this.putIfNotNull(solaris, ICON_SOLARIS_TINY, solarisDom.getAttributeValue(ICON_SOLARIS_TINY));
        return Collections.unmodifiableMap(solaris);
    }

    public boolean getWindowsUseIco() {
        Element winDom = this.dom.getChild("win");
        if (winDom == null) {
            return false;
        }
        boolean useIco = Boolean.parseBoolean(winDom.getAttributeValue("useIco"));
        return useIco;
    }

    public Map<String, String> getWindowsIcon() {
        Element winDom = this.dom.getChild("win");
        if (winDom == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> windows = new HashMap<String, String>();
        if (this.getWindowsUseIco()) {
            Element ico = winDom.getChild("ico");
            if (ico != null) {
                this.putIfNotNull(windows, ICON_WINDOWS_ICO_PATH, ico.getAttributeValue(ICON_WINDOWS_ICO_PATH));
            }
        } else {
            Element bmp = winDom.getChild("bmp");
            if (bmp != null) {
                this.putIfNotNull(windows, ICON_WINDOWS_SMALL_HIGH, bmp.getAttributeValue(ICON_WINDOWS_SMALL_HIGH));
                this.putIfNotNull(windows, ICON_WINDOWS_SMALL_LOW, bmp.getAttributeValue(ICON_WINDOWS_SMALL_LOW));
                this.putIfNotNull(windows, ICON_WINDOWS_MEDIUM_HIGH, bmp.getAttributeValue(ICON_WINDOWS_MEDIUM_HIGH));
                this.putIfNotNull(windows, ICON_WINDOWS_MEDIUM_LOW, bmp.getAttributeValue(ICON_WINDOWS_MEDIUM_LOW));
                this.putIfNotNull(windows, ICON_WINDOWS_LARGE_HIGH, bmp.getAttributeValue(ICON_WINDOWS_LARGE_HIGH));
                this.putIfNotNull(windows, ICON_WINDOWS_LARGE_LOW, bmp.getAttributeValue(ICON_WINDOWS_LARGE_LOW));
                this.putIfNotNull(windows, ICON_WINDOWS_EXTRA_LARGE_HIGH, bmp.getAttributeValue(ICON_WINDOWS_EXTRA_LARGE_HIGH));
            }
        }
        return Collections.unmodifiableMap(windows);
    }

    private void putIfNotNull(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

