/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director.runtime;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.sisu.equinox.launching.EquinoxLauncher;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.core.utils.TychoVersion;
import org.eclipse.tycho.p2.tools.director.shared.DirectorCommandException;
import org.eclipse.tycho.p2.tools.director.shared.DirectorRuntime;
import org.eclipse.tycho.plugins.p2.director.runtime.StandaloneDirectorRuntime;

@Component(role=StandaloneDirectorRuntimeFactory.class)
public class StandaloneDirectorRuntimeFactory {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private EquinoxServiceFactory osgiServices;
    @Requirement
    private EquinoxLauncher launchHelper;
    @Requirement
    private Logger logger;

    public StandaloneDirectorRuntime createStandaloneDirector(File installLocation, ArtifactRepository localMavenRepository) throws MojoExecutionException {
        this.installStandaloneDirector(installLocation, localMavenRepository);
        return new StandaloneDirectorRuntime(installLocation, this.launchHelper, this.logger);
    }

    private void installStandaloneDirector(File installLocation, ArtifactRepository localMavenRepository) throws MojoExecutionException {
        DirectorRuntime bootstrapDirector = (DirectorRuntime)this.osgiServices.getService(DirectorRuntime.class);
        try {
            URI directorRuntimeRepo = URI.create("jar:" + this.getDirectorRepositoryZip(localMavenRepository).toURI() + "!/");
            DirectorRuntime.Command command = bootstrapDirector.newInstallCommand();
            command.addMetadataSources(Arrays.asList(directorRuntimeRepo));
            command.addArtifactSources(Arrays.asList(directorRuntimeRepo));
            command.addUnitToInstall("tycho-standalone-p2-director");
            command.setProfileName("director");
            command.setDestination(installLocation);
            command.setEnvironment(new TargetEnvironment("linux", "gtk", "x86_64"));
            this.logger.info("Installing a standalone p2 Director...");
            command.execute();
        }
        catch (DirectorCommandException e) {
            throw new MojoExecutionException("Could not install the standalone director", (Exception)((Object)e));
        }
    }

    private File getDirectorRepositoryZip(ArtifactRepository localMavenRepository) {
        Artifact artifact = this.repositorySystem.createArtifact("org.eclipse.tycho", "tycho-standalone-p2-director", TychoVersion.getTychoVersion(), "eclipse-repository");
        return new File(localMavenRepository.getBasedir(), localMavenRepository.pathOf(artifact));
    }
}

