/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.p2.facade.RepositoryReferenceTool;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.director.shared.DirectorCommandException;
import org.eclipse.tycho.p2.tools.director.shared.DirectorRuntime;
import org.eclipse.tycho.plugins.p2.director.AbstractProductMojo;
import org.eclipse.tycho.plugins.p2.director.Product;
import org.eclipse.tycho.plugins.p2.director.ProfileName;
import org.eclipse.tycho.plugins.p2.director.runtime.StandaloneDirectorRuntimeFactory;

@Mojo(name="materialize-products", defaultPhase=LifecyclePhase.PACKAGE)
public final class DirectorMojo
extends AbstractProductMojo {
    @Component
    private EquinoxServiceFactory osgiServices;
    @Component
    private RepositoryReferenceTool repositoryReferenceTool;
    @Component
    private StandaloneDirectorRuntimeFactory standaloneDirectorFactory;
    @Parameter(defaultValue="DefaultProfile")
    private String profile;
    @Parameter
    private List<ProfileName> profileNames;
    @Parameter(defaultValue="true")
    private boolean installFeatures;
    @Parameter(defaultValue="targetPlatform")
    private InstallationSource source;
    @Parameter(defaultValue="internal")
    private DirectorRuntimeType directorRuntime;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Product> products = this.getProductConfig().getProducts();
        if (products.isEmpty()) {
            this.getLog().info((CharSequence)"No product definitions found. Nothing to do.");
        }
        DirectorRuntime director = this.getDirectorRuntime();
        RepositoryReferences sources = this.getSourceRepositories();
        for (Product product : products) {
            for (TargetEnvironment env : this.getEnvironments()) {
                DirectorRuntime.Command command = director.newInstallCommand();
                File destination = this.getProductMaterializeDirectory(product, env);
                String rootFolder = product.getRootFolder(env.getOs());
                if (rootFolder != null && rootFolder.length() > 0) {
                    destination = new File(destination, rootFolder);
                }
                command.addMetadataSources((Iterable)sources.getMetadataRepositories());
                command.addArtifactSources((Iterable)sources.getArtifactRepositories());
                command.addUnitToInstall(product.getId());
                for (DependencySeed seed : product.getAdditionalInstallationSeeds()) {
                    command.addUnitToInstall(seed);
                }
                command.setDestination(destination);
                command.setProfileName(ProfileName.getNameForEnvironment(env, this.profileNames, this.profile));
                command.setEnvironment(env);
                command.setInstallFeatures(this.installFeatures);
                this.getLog().info((CharSequence)("Installing product " + product.getId() + " for environment " + env + " to " + destination.getAbsolutePath()));
                try {
                    command.execute();
                }
                catch (DirectorCommandException e) {
                    throw new MojoFailureException("Installation of product " + product.getId() + " for environment " + env + " failed", (Throwable)e);
                }
            }
        }
    }

    private DirectorRuntime getDirectorRuntime() throws MojoFailureException, MojoExecutionException {
        switch (this.directorRuntime) {
            case internal: {
                return (DirectorRuntime)this.osgiServices.getService(DirectorRuntime.class);
            }
            case standalone: {
                return this.standaloneDirectorFactory.createStandaloneDirector(this.getBuildDirectory().getChild("director"), this.getSession().getLocalRepository(), this.getForkedProcessTimeoutInSeconds());
            }
        }
        throw new MojoFailureException("Unsupported value for attribute 'directorRuntime': \"" + (Object)((Object)this.directorRuntime) + "\"");
    }

    private RepositoryReferences getSourceRepositories() throws MojoExecutionException, MojoFailureException {
        switch (this.source) {
            case targetPlatform: {
                return this.getTargetPlatformRepositories();
            }
            case repository: {
                return this.getBuildOutputRepository();
            }
        }
        throw new MojoFailureException("Unsupported value for attribute 'source': \"" + (Object)((Object)this.source) + "\"");
    }

    private RepositoryReferences getBuildOutputRepository() {
        File buildOutputRepository = this.getBuildDirectory().getChild("repository");
        RepositoryReferences result = new RepositoryReferences();
        result.addMetadataRepository(buildOutputRepository);
        result.addArtifactRepository(buildOutputRepository);
        return result;
    }

    private RepositoryReferences getTargetPlatformRepositories() throws MojoExecutionException, MojoFailureException {
        int flags = RepositoryReferenceTool.REPOSITORIES_INCLUDE_CURRENT_MODULE;
        return this.repositoryReferenceTool.getVisibleRepositories(this.getProject(), this.getSession(), flags);
    }

    public static enum DirectorRuntimeType {
        internal,
        standalone;

    }

    public static enum InstallationSource {
        targetPlatform,
        repository;

    }
}

