/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director;

import java.io.File;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.BuildDirectory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.plugins.p2.director.Product;
import org.eclipse.tycho.plugins.p2.director.ProductConfig;

abstract class AbstractProductMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Parameter
    private List<Product> products;
    @Parameter(property="p2.timeout", defaultValue="0")
    private int forkedProcessTimeoutInSeconds;

    AbstractProductMojo() {
    }

    int getForkedProcessTimeoutInSeconds() {
        return this.forkedProcessTimeoutInSeconds;
    }

    MavenProject getProject() {
        return this.project;
    }

    MavenSession getSession() {
        return this.session;
    }

    BuildDirectory getBuildDirectory() {
        return DefaultReactorProject.adapt((MavenProject)this.project).getBuildDirectory();
    }

    File getProductsBuildDirectory() {
        return this.getBuildDirectory().getChild("products");
    }

    File getProductMaterializeDirectory(Product product, TargetEnvironment env) {
        return new File(this.getProductsBuildDirectory(), product.getId() + "/" + AbstractProductMojo.getOsWsArch(env, '/'));
    }

    List<TargetEnvironment> getEnvironments() {
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration((ReactorProject)DefaultReactorProject.adapt((MavenProject)this.project));
        return configuration.getEnvironments();
    }

    ProductConfig getProductConfig() throws MojoFailureException {
        return new ProductConfig(this.products, TychoProjectUtils.getDependencySeeds((ReactorProject)DefaultReactorProject.adapt((MavenProject)this.project)));
    }

    static String getOsWsArch(TargetEnvironment env, char separator) {
        return env.getOs() + separator + env.getWs() + separator + env.getArch();
    }
}

