/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.tycho.DependencySeed;

public final class Product {
    private String id;
    private String attachId;
    private String rootFolder;
    private Map<String, String> rootFolders;
    private String archiveFileName;
    private List<DependencySeed> extraInstallationSeeds;
    private boolean multiPlatformPackage;

    public Product() {
    }

    Product(String id) {
        this.id = id;
    }

    Product(String id, String attachId) {
        this.id = id;
        this.attachId = attachId;
    }

    public String getId() {
        return this.id;
    }

    public String getAttachId() {
        return this.attachId;
    }

    public boolean isMultiPlatformPackage() {
        return this.multiPlatformPackage;
    }

    public String getRootFolder(String os) {
        Object result = null;
        result = this.rootFolders == null ? this.rootFolder : (this.rootFolders.get(os) == null ? this.rootFolder : this.rootFolders.get(os));
        if ("macosx".equals(os)) {
            if (result == null) {
                result = "Eclipse.app";
            } else if (!((String)result).endsWith(".app")) {
                result = (String)result + ".app";
            }
        }
        return result;
    }

    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public void addInstallationSeed(DependencySeed seed) {
        if (this.extraInstallationSeeds == null) {
            this.extraInstallationSeeds = new ArrayList<DependencySeed>();
        }
        this.extraInstallationSeeds.add(seed);
    }

    public List<DependencySeed> getAdditionalInstallationSeeds() {
        if (this.extraInstallationSeeds == null) {
            return Collections.emptyList();
        }
        return this.extraInstallationSeeds;
    }

    public String toString() {
        return "Product [id=" + this.id + ", attachId=" + this.attachId + "]";
    }

    public int hashCode() {
        return Objects.hash(this.attachId, this.id, this.archiveFileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Product)) return false;
        Product other = (Product)obj;
        if (!Objects.equals(this.id, other.id)) return false;
        if (!Objects.equals(this.attachId, other.attachId)) return false;
        if (!Objects.equals(this.archiveFileName, other.archiveFileName)) return false;
        return true;
    }
}

