/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director.runtime;

import java.io.File;
import java.util.ArrayList;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.launching.EquinoxLauncher;
import org.eclipse.sisu.equinox.launching.LaunchConfiguration;
import org.eclipse.sisu.equinox.launching.internal.EquinoxInstallationLaunchConfiguration;
import org.eclipse.tycho.p2.tools.director.shared.AbstractDirectorApplicationCommand;
import org.eclipse.tycho.p2.tools.director.shared.DirectorCommandException;
import org.eclipse.tycho.p2.tools.director.shared.DirectorRuntime;

public class StandaloneDirectorRuntime
implements DirectorRuntime {
    private final File runtimeLocation;
    private final EquinoxLauncher launchHelper;
    private Logger logger;
    private final int forkedProcessTimeoutInSeconds;

    StandaloneDirectorRuntime(File runtimeLocation, EquinoxLauncher launchHelper, int forkedProcessTimeoutInSeconds, Logger logger) {
        this.runtimeLocation = runtimeLocation;
        this.launchHelper = launchHelper;
        this.logger = logger;
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    public DirectorRuntime.Command newInstallCommand() {
        return new AbstractDirectorApplicationCommand(){

            public void execute() throws DirectorCommandException {
                ArrayList<String> programArguments = new ArrayList<String>();
                programArguments.add("-application");
                programArguments.add("org.eclipse.equinox.p2.director");
                programArguments.addAll(this.getDirectorApplicationArguments());
                EquinoxInstallationLaunchConfiguration launch = new EquinoxInstallationLaunchConfiguration(StandaloneDirectorRuntime.this.runtimeLocation, programArguments);
                StandaloneDirectorRuntime.this.logger.info("Using the standalone p2 Director to install the product");
                int exitCode = StandaloneDirectorRuntime.this.launchHelper.execute((LaunchConfiguration)launch, StandaloneDirectorRuntime.this.forkedProcessTimeoutInSeconds);
                if (exitCode != 0) {
                    throw new DirectorCommandException("Call to p2 director application failed with exit code " + exitCode + ". Program arguments were: " + programArguments + ".");
                }
            }
        };
    }
}

