/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.tycho.DependencySeed;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.director.shared.DirectorCommandException;
import org.eclipse.tycho.p2.tools.director.shared.DirectorRuntime;
import org.eclipse.tycho.p2tools.RepositoryReferenceTool;
import org.eclipse.tycho.p2tools.copiedfromp2.PhaseSetFactory;
import org.eclipse.tycho.plugins.p2.director.AbstractProductMojo;
import org.eclipse.tycho.plugins.p2.director.Product;
import org.eclipse.tycho.plugins.p2.director.ProfileName;
import org.eclipse.tycho.plugins.p2.director.runtime.StandaloneDirectorRuntimeFactory;

@Mojo(name="materialize-products", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public final class MaterializeProductsMojo
extends AbstractProductMojo {
    private static final Object LOCK = new Object();
    @Component
    private MojoExecution execution;
    @Component
    private RepositoryReferenceTool repositoryReferenceTool;
    @Component
    private StandaloneDirectorRuntimeFactory standaloneDirectorFactory;
    @Component
    DirectorRuntime director;
    @Parameter(defaultValue="DefaultProfile")
    private String profile;
    @Parameter
    private List<ProfileName> profileNames;
    @Parameter(defaultValue="true")
    private boolean installFeatures;
    @Parameter
    private Map<String, String> profileProperties;
    @Parameter(defaultValue="targetPlatform")
    private InstallationSource source;
    @Parameter(defaultValue="internal")
    private DirectorRuntimeType directorRuntime;
    @Parameter
    private boolean parallel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Product> products = this.getProductConfig().getProducts();
        if (products.isEmpty()) {
            this.getLog().info((CharSequence)"No product definitions found, nothing to do");
            return;
        }
        DirectorRuntime director = this.getDirectorRuntime();
        RepositoryReferences sources = this.getSourceRepositories();
        if (this.parallel) {
            ExecutorService executorService = Executors.newWorkStealingPool();
            ExecutorCompletionService<Void> service = new ExecutorCompletionService<Void>(executorService);
            try {
                int tasks = 0;
                for (Product product : products) {
                    for (TargetEnvironment env : this.getEnvironments()) {
                        service.submit(() -> {
                            this.buildProduct(director, sources, product, env);
                            return null;
                        });
                        ++tasks;
                    }
                }
                for (int i = 0; i < tasks; ++i) {
                    try {
                        service.take().get();
                        continue;
                    }
                    catch (InterruptedException e) {
                        executorService.shutdown();
                        return;
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof RuntimeException) {
                            RuntimeException rte = (RuntimeException)cause;
                            throw rte;
                        }
                        if (cause instanceof MojoFailureException) {
                            MojoFailureException mfe = (MojoFailureException)cause;
                            throw mfe;
                        }
                        if (cause instanceof MojoExecutionException) {
                            MojoExecutionException mee = (MojoExecutionException)cause;
                            throw mee;
                        }
                        throw new MojoFailureException("internal error", (Throwable)e);
                    }
                }
            }
            finally {
                executorService.shutdown();
            }
        }
        Object object = LOCK;
        synchronized (object) {
            for (Product product : products) {
                for (TargetEnvironment env : this.getEnvironments()) {
                    this.buildProduct(director, sources, product, env);
                }
            }
        }
    }

    private void buildProduct(DirectorRuntime director, RepositoryReferences sources, Product product, TargetEnvironment env) throws MojoFailureException {
        DirectorRuntime.Command command = director.newInstallCommand(this.execution.getExecutionId() + " - " + product.getId() + " - " + env);
        command.setPhaseSet(PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{"checkTrust"}));
        File destination = this.getProductMaterializeDirectory(product, env);
        String rootFolder = product.getRootFolder(env.getOs());
        if (rootFolder != null && !rootFolder.isEmpty()) {
            destination = new File(destination, rootFolder);
        }
        command.setBundlePool(this.getProductBundlePoolDirectory(product));
        command.addMetadataSources((Iterable)sources.getMetadataRepositories());
        command.addArtifactSources((Iterable)sources.getArtifactRepositories());
        command.addUnitToInstall(product.getId());
        for (DependencySeed seed : product.getAdditionalInstallationSeeds()) {
            command.addUnitToInstall(seed);
        }
        command.setDestination(destination);
        command.setProfileName(ProfileName.getNameForEnvironment(env, this.profileNames, this.profile));
        command.setEnvironment(env);
        command.setInstallFeatures(this.installFeatures);
        command.setProfileProperties(this.profileProperties);
        this.getLog().info((CharSequence)("Installing product " + product.getId() + " for environment " + env + " to " + destination.getAbsolutePath()));
        try {
            command.execute();
        }
        catch (DirectorCommandException e) {
            throw new MojoFailureException("Installation of product " + product.getId() + " for environment " + env + " failed", (Throwable)e);
        }
    }

    private DirectorRuntime getDirectorRuntime() throws MojoFailureException, MojoExecutionException {
        return switch (this.directorRuntime) {
            case DirectorRuntimeType.internal -> this.director;
            case DirectorRuntimeType.standalone -> this.standaloneDirectorFactory.createStandaloneDirector(this.getBuildDirectory().getChild("director"), this.getSession().getLocalRepository(), this.getForkedProcessTimeoutInSeconds());
            default -> throw new MojoFailureException("Unsupported value for attribute 'directorRuntime': \"" + this.directorRuntime + "\"");
        };
    }

    private RepositoryReferences getSourceRepositories() throws MojoExecutionException, MojoFailureException {
        return switch (this.source) {
            case InstallationSource.targetPlatform -> this.getTargetPlatformRepositories();
            case InstallationSource.repository -> this.getBuildOutputRepository();
            default -> throw new MojoFailureException("Unsupported value for attribute 'source': \"" + this.source + "\"");
        };
    }

    private RepositoryReferences getBuildOutputRepository() {
        File buildOutputRepository = this.getBuildDirectory().getChild("repository");
        RepositoryReferences result = new RepositoryReferences();
        result.addMetadataRepository(buildOutputRepository);
        result.addArtifactRepository(buildOutputRepository);
        return result;
    }

    private RepositoryReferences getTargetPlatformRepositories() throws MojoExecutionException, MojoFailureException {
        int flags = 1;
        return this.repositoryReferenceTool.getVisibleRepositories(this.getProject(), this.getSession(), flags);
    }

    public static enum DirectorRuntimeType {
        internal,
        standalone;

    }

    public static enum InstallationSource {
        targetPlatform,
        repository;

    }
}

