/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.tar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.eclipse.tycho.plugins.tar.FilePermissionHelper;

public class TarGzArchiver {
    private File destFile;
    private List<File> sourceDirs = new ArrayList<File>();
    private Log log = new SystemStreamLog();

    public void setLog(Log log) {
        this.log = log;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void addDirectory(File directory) {
        this.sourceDirs.add(directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createArchive() throws IOException {
        this.validate();
        this.log.info((CharSequence)("Building tar: " + this.destFile));
        try (TarArchiveOutputStream tarStream = null;){
            this.destFile.getAbsoluteFile().getParentFile().mkdirs();
            GzipCompressorOutputStream gzipStream = new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.destFile)));
            tarStream = new TarArchiveOutputStream((OutputStream)gzipStream, "UTF-8");
            tarStream.setLongFileMode(3);
            tarStream.setBigNumberMode(2);
            for (File sourceDir : this.sourceDirs) {
                for (File child : sourceDir.listFiles()) {
                    this.addToTarRecursively(sourceDir, child, tarStream);
                }
            }
        }
    }

    private void validate() throws IOException {
        for (File sourceDir : this.sourceDirs) {
            if (sourceDir.isDirectory()) continue;
            throw new IOException(sourceDir + " is not a directory");
        }
    }

    private void addToTarRecursively(File tarRootDir, File source, TarArchiveOutputStream tarStream) throws IOException {
        File[] children;
        TarArchiveEntry tarEntry = this.createTarEntry(tarRootDir, source);
        tarStream.putArchiveEntry(tarEntry);
        if (source.isFile() && !tarEntry.isSymbolicLink()) {
            TarGzArchiver.copyFileContentToTarStream(source, tarStream);
        }
        tarStream.closeArchiveEntry();
        if (!(!source.isDirectory() || tarEntry.isSymbolicLink() && this.resolvesBelow(source, tarRootDir) || (children = source.listFiles()) == null)) {
            for (File child : children) {
                this.addToTarRecursively(tarRootDir, child, tarStream);
            }
        }
    }

    private TarArchiveEntry createTarEntry(File tarRootDir, File source) throws IOException {
        TarArchiveEntry tarEntry;
        String pathInTar = TarGzArchiver.slashify(tarRootDir.toPath().relativize(source.toPath()));
        this.log.debug((CharSequence)("Adding entry " + pathInTar));
        if (TarGzArchiver.isSymbolicLink(source) && this.resolvesBelow(source, tarRootDir)) {
            tarEntry = new TarArchiveEntry(pathInTar, 50);
            tarEntry.setLinkName(TarGzArchiver.slashify(this.getRelativeSymLinkTarget(source, source.getParentFile())));
        } else {
            tarEntry = new TarArchiveEntry(source, pathInTar);
        }
        PosixFileAttributes attrs = this.getAttributes(source);
        if (attrs != null) {
            tarEntry.setMode(FilePermissionHelper.toOctalFileMode(attrs.permissions()));
        }
        tarEntry.setModTime(source.lastModified());
        return tarEntry;
    }

    private static String slashify(Path path) {
        String pathString = path.toString();
        if (File.separatorChar == '/') {
            return pathString;
        }
        return pathString.replace(File.separatorChar, '/');
    }

    private PosixFileAttributes getAttributes(File source) {
        PosixFileAttributes attrs;
        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(source.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        if (fileAttributeView == null) {
            return null;
        }
        try {
            attrs = fileAttributeView.readAttributes();
        }
        catch (IOException e) {
            return null;
        }
        return attrs;
    }

    private static void copyFileContentToTarStream(File source, TarArchiveOutputStream tarStream) throws IOException {
        try (BufferedInputStream sourceStream = new BufferedInputStream(new FileInputStream(source));){
            sourceStream.transferTo((OutputStream)tarStream);
        }
    }

    private boolean resolvesBelow(File source, File baseDir) throws IOException {
        return !this.getRelativeSymLinkTarget(source, baseDir).startsWith("..");
    }

    private Path getRelativeSymLinkTarget(File source, File baseDir) throws IOException {
        Path sourcePath = source.toPath();
        Path linkTarget = Files.readSymbolicLink(sourcePath);
        Path resolvedLinkTarget = sourcePath.getParent().resolve(linkTarget);
        Path relative = baseDir.toPath().relativize(resolvedLinkTarget);
        Path normalizedSymLinkPath = relative.normalize();
        this.log.debug((CharSequence)("Computed symlink target path " + TarGzArchiver.slashify(normalizedSymLinkPath) + " for symlink " + source + " relative to " + baseDir));
        return normalizedSymLinkPath;
    }

    private static boolean isSymbolicLink(File file) {
        return Files.isSymbolicLink(file.toPath());
    }
}

