/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.p2.facade.internal.ArtifactFacade;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;
import org.eclipse.tycho.p2.resolver.facade.P2ResolverFactory;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;

public class PomDependencyProcessor {
    private final MavenSession session;
    private final RepositorySystem repositorySystem;
    private final Logger logger;
    private P2ResolverFactory resolverFactory;
    private final LocalRepositoryP2Indices localRepoIndices;

    public PomDependencyProcessor(MavenSession session, RepositorySystem repositorySystem, P2ResolverFactory resolverFactory, LocalRepositoryP2Indices localRepoIndices, Logger logger) {
        this.session = session;
        this.repositorySystem = repositorySystem;
        this.logger = logger;
        this.resolverFactory = resolverFactory;
        this.localRepoIndices = localRepoIndices;
    }

    PomDependencyCollector collectPomDependencies(MavenProject project, Collection<Artifact> transitivePomDependencies) {
        TychoRepositoryIndex p2ArtifactsInLocalRepo = this.localRepoIndices.getArtifactsIndex();
        PomDependencyCollector result = this.resolverFactory.newPomDependencyCollector();
        result.setProjectLocation(project.getBasedir());
        for (Artifact artifact : transitivePomDependencies) {
            if ("system".equals(artifact.getScope())) continue;
            P2DataArtifacts p2Data = new P2DataArtifacts(artifact);
            p2Data.resolve(this.session, project.getRemoteArtifactRepositories());
            if (p2Data.p2MetadataXml.isAvailable() && p2Data.p2ArtifactsXml.isAvailable()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("P2TargetPlatformResolver: Using existing metadata of " + artifact.toString());
                }
                result.addArtifactWithExistingMetadata((IArtifactFacade)new ArtifactFacade(artifact), (IArtifactFacade)new ArtifactFacade(p2Data.p2MetadataXml.artifact));
                p2ArtifactsInLocalRepo.addGav(new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
                continue;
            }
            if (!p2Data.p2MetadataXml.isAvailable() && !p2Data.p2ArtifactsXml.isAvailable()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("P2resolver.addMavenArtifact " + artifact.toString());
                }
                result.publishAndAddArtifactIfBundleArtifact((IArtifactFacade)new ArtifactFacade(artifact));
                continue;
            }
            this.failDueToPartialP2Data(artifact, p2Data);
        }
        return result;
    }

    private void failDueToPartialP2Data(Artifact artifact, P2DataArtifacts p2Data) {
        String p2MetadataFileName = "p2metadata.xml";
        String p2ArtifactsFileName = "p2artifacts.xml";
        String artifactGAV = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
        String message = "Only one of the p2 data artifacts " + p2MetadataFileName + "/" + p2ArtifactsFileName + " of the POM dependency " + artifactGAV + " could be resolved";
        throw new RuntimeException(message);
    }

    private static class ResolvableArtifact {
        final Artifact artifact;

        ResolvableArtifact(Artifact artifact) {
            this.artifact = artifact;
        }

        void resolve(RepositorySystem repositorySystem, MavenSession session, List<ArtifactRepository> remoteMavenRepositories) {
            session.getLocalRepository().find(this.artifact);
        }

        boolean isAvailable() {
            return this.artifact.getFile() != null && this.artifact.getFile().canRead();
        }
    }

    private class P2DataArtifacts {
        final ResolvableArtifact p2MetadataXml;
        final ResolvableArtifact p2ArtifactsXml;

        P2DataArtifacts(Artifact mainArtifact) {
            this.p2MetadataXml = this.getAttachedArtifactFor(mainArtifact, "p2metadata", "xml");
            this.p2ArtifactsXml = this.getAttachedArtifactFor(mainArtifact, "p2artifacts", "xml");
        }

        private ResolvableArtifact getAttachedArtifactFor(Artifact mainArtifact, String classifier, String extension) {
            Artifact artifact = PomDependencyProcessor.this.repositorySystem.createArtifactWithClassifier(mainArtifact.getGroupId(), mainArtifact.getArtifactId(), mainArtifact.getVersion(), extension, classifier);
            return new ResolvableArtifact(artifact);
        }

        void resolve(MavenSession session, List<ArtifactRepository> remoteMavenRepositories) {
            this.p2MetadataXml.resolve(PomDependencyProcessor.this.repositorySystem, session, remoteMavenRepositories);
            this.p2ArtifactsXml.resolve(PomDependencyProcessor.this.repositorySystem, session, remoteMavenRepositories);
        }
    }
}

