/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2;

import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

@Mojo(name="update-local-index")
public class UpdateLocalIndexMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Component
    private EquinoxServiceFactory serviceFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        LocalRepositoryP2Indices localRepoIndices = (LocalRepositoryP2Indices)this.serviceFactory.getService(LocalRepositoryP2Indices.class);
        GAV gav = new GAV(this.project.getGroupId(), this.project.getArtifactId(), this.project.getArtifact().getVersion());
        TychoRepositoryIndex artifactsIndex = localRepoIndices.getArtifactsIndex();
        TychoRepositoryIndex metadataIndex = localRepoIndices.getMetadataIndex();
        try {
            this.addGavAndSave(gav, artifactsIndex);
            this.addGavAndSave(gav, metadataIndex);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not update local repository index", (Exception)e);
        }
    }

    private void addGavAndSave(GAV gav, TychoRepositoryIndex index) throws IOException {
        index.addGav(gav);
        index.save();
    }
}

