/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.p2maven.InstallableUnitGenerator;

@Mojo(name="dependency-tree", requiresProject=true, threadSafe=true, requiresDependencyCollection=ResolutionScope.TEST)
public class DependenciesTreeMojo
extends AbstractMojo {
    private static final Comparator<IInstallableUnit> COMPARATOR = Comparator.comparing(IVersionedId::getId, String.CASE_INSENSITIVE_ORDER);
    @Parameter(property="project")
    private MavenProject project;
    @Component
    private InstallableUnitGenerator generator;
    @Component
    private LegacySupport legacySupport;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList initial;
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        Optional optional = TychoProjectUtils.getOptionalDependencyArtifacts((ReactorProject)reactorProject);
        if (optional.isEmpty()) {
            return;
        }
        HashSet<String> written = new HashSet<String>();
        written.add(this.project.getId());
        this.getLog().info((CharSequence)this.project.getId());
        List artifacts = ((DependencyArtifacts)optional.get()).getArtifacts();
        Map<IInstallableUnit, Set<ReactorProject>> projectMap = artifacts.stream().filter(a -> a.getMavenProject() != null).flatMap(a -> a.getInstallableUnits().stream().map(iu -> new AbstractMap.SimpleEntry<IInstallableUnit, ReactorProject>((IInstallableUnit)iu, a.getMavenProject()))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
        Set units = artifacts.stream().flatMap(d -> d.getInstallableUnits().stream()).collect(Collectors.toCollection(HashSet::new));
        reactorProject.getDependencyMetadata();
        try {
            initial = new ArrayList(this.generator.getInstallableUnits(this.project, this.legacySupport.getSession(), false));
        }
        catch (CoreException e) {
            throw new MojoFailureException((Throwable)e);
        }
        units.removeAll(initial);
        int size = initial.size();
        for (int i = 0; i < size; ++i) {
            IInstallableUnit unit = (IInstallableUnit)initial.get(i);
            this.printUnit(unit, null, units, projectMap, 0, i == size - 1);
        }
        if (!units.isEmpty()) {
            this.getLog().info((CharSequence)"Units that cannot be matched to any requirement:");
            for (IInstallableUnit unit : units) {
                this.getLog().info((CharSequence)unit.toString());
            }
        }
    }

    private void printUnit(IInstallableUnit unit, IRequirement satisfies, Set<IInstallableUnit> units, Map<IInstallableUnit, Set<ReactorProject>> projectMap, int indent, boolean last) {
        Set<ReactorProject> mappedProjects;
        StringBuffer line = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            line.append("   ");
        }
        line.append("+- ");
        line.append(unit.getId());
        line.append(" (");
        line.append(unit.getVersion());
        line.append(")");
        if (satisfies != null) {
            line.append(" satisfies ");
            line.append(satisfies);
        }
        if ((mappedProjects = projectMap.get(unit)) != null && !mappedProjects.isEmpty()) {
            line.append(" --> ");
            line.append(mappedProjects.stream().map(ReactorProject::getId).sorted().collect(Collectors.joining(", ", "[", "]")));
        }
        this.getLog().info((CharSequence)line.toString());
        ArrayList collected = new ArrayList();
        HashMap requirementsMap = new HashMap();
        Stream.concat(unit.getRequirements().stream(), unit.getMetaRequirements().stream()).forEach(requirement -> {
            Iterator iterator = units.iterator();
            while (iterator.hasNext()) {
                IInstallableUnit other = (IInstallableUnit)iterator.next();
                if (!other.satisfies(requirement)) continue;
                collected.add(other);
                requirementsMap.put(other, requirement);
                iterator.remove();
            }
        });
        Collections.sort(collected, COMPARATOR);
        int size = collected.size();
        for (int i = 0; i < size; ++i) {
            IInstallableUnit iu = (IInstallableUnit)collected.get(i);
            this.printUnit(iu, (IRequirement)requirementsMap.get(iu), units, projectMap, indent + 1, i == size - 1);
        }
    }
}

