/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.core.osgitools.BaselineService;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.p2.metadata.IP2Artifact;
import org.eclipse.tycho.plugins.p2.BaselineMode;
import org.eclipse.tycho.plugins.p2.BaselineReplace;
import org.eclipse.tycho.plugins.p2.Repository;
import org.eclipse.tycho.zipcomparator.internal.CompoundArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;

@Component(role=BaselineValidator.class)
public class BaselineValidator {
    @Requirement
    private Logger log;
    @Requirement(hint="zip")
    private ArtifactComparator zipComparator;
    @Requirement
    BaselineService baselineService;

    public Map<String, IP2Artifact> validateAndReplace(MavenProject project, ArtifactComparator.ComparisonData data, Map<String, IP2Artifact> reactorMetadata, List<Repository> baselineRepositories, BaselineMode baselineMode, BaselineReplace baselineReplace) throws IOException, MojoExecutionException {
        Map<String, IP2Artifact> result = reactorMetadata;
        if (baselineMode != BaselineMode.disable && baselineRepositories != null && !baselineRepositories.isEmpty()) {
            ArrayList<MavenRepositoryLocation> repositories = new ArrayList<MavenRepositoryLocation>();
            for (Repository repository : baselineRepositories) {
                if (repository.getUrl() == null) continue;
                repositories.add(new MavenRepositoryLocation(repository.getId(), repository.getUrl()));
            }
            File baselineBasedir = new File(project.getBuild().getDirectory(), "baseline");
            Map baselineMetadata = this.baselineService.getProjectBaseline(repositories, reactorMetadata, baselineBasedir);
            if (baselineMetadata != null) {
                CompoundArtifactDelta delta = this.getDelta(this.baselineService, baselineMetadata, reactorMetadata, data);
                if (delta != null) {
                    if (data.writeDelta()) {
                        File logdir = new File(project.getBuild().getDirectory(), "artifactcomparison");
                        this.log.info("Artifact comparison detailed log directory " + logdir.getAbsolutePath());
                        for (Map.Entry classifier : delta.getMembers().entrySet()) {
                            ((ArtifactDelta)classifier.getValue()).writeDetails(new File(logdir, (String)classifier.getKey()));
                        }
                    }
                    if (baselineMode == BaselineMode.fail || baselineMode == BaselineMode.failCommon && !this.isMissingOnlyDelta((ArtifactDelta)delta)) {
                        throw new MojoExecutionException(delta.getDetailedMessage());
                    }
                    this.log.warn(project.toString() + ": " + delta.getDetailedMessage());
                }
                if (baselineReplace != BaselineReplace.none) {
                    result = new LinkedHashMap<String, IP2Artifact>();
                    ArrayList<String> replaced = new ArrayList<String>();
                    for (Map.Entry artifact : baselineMetadata.entrySet()) {
                        File baseLineFile = ((IP2Artifact)artifact.getValue()).getLocation();
                        String string = (String)artifact.getKey();
                        File reactorFile = reactorMetadata.get(string).getLocation();
                        if (baseLineFile.isFile() && baseLineFile.length() == 0L) {
                            this.log.error("Baseline file " + baseLineFile.getAbsolutePath() + " is empty. Will not replace " + reactorFile);
                            continue;
                        }
                        FileUtils.copyFile((File)baseLineFile, (File)reactorFile);
                        result.put(string, (IP2Artifact)artifact.getValue());
                        if (string == null) continue;
                        replaced.add(string);
                    }
                    ArrayList<String> removed = new ArrayList<String>();
                    ArrayList<String> inconsistent = new ArrayList<String>();
                    for (Map.Entry entry : reactorMetadata.entrySet()) {
                        String classifier = (String)entry.getKey();
                        IP2Artifact artifact = (IP2Artifact)entry.getValue();
                        if (classifier == null || artifact == null) continue;
                        if (baselineReplace == BaselineReplace.all && !baselineMetadata.containsKey(classifier)) {
                            List attachedArtifacts = project.getAttachedArtifacts();
                            try {
                                attachedArtifacts.removeIf(a -> classifier.equals(a.getClassifier()));
                            }
                            catch (UnsupportedOperationException e) {
                                List list = attachedArtifacts.stream().filter(a -> !classifier.equals(a.getClassifier())).collect(Collectors.toCollection(ArrayList::new));
                                try {
                                    MethodUtils.invokeMethod((Object)project, (boolean)true, (String)"setAttachedArtifacts", (Object[])new Object[]{list});
                                }
                                catch (ReflectiveOperationException ignored) {
                                    this.log.warn("The attached artifact " + classifier + " is not present in the baseline, but could not be removed");
                                }
                            }
                            artifact.getLocation().delete();
                            removed.add(classifier);
                            continue;
                        }
                        inconsistent.add(classifier);
                        result.put(classifier, artifact);
                    }
                    DefaultReactorProject.adapt((MavenProject)project).setContextValue(TychoConstants.KEY_BASELINE_REPLACE_ARTIFACT_MAIN, (Object)true);
                    if (this.log.isInfoEnabled()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append(project.toString());
                        msg.append("\n    The main artifact has been replaced with the baseline version.\n");
                        if (!replaced.isEmpty()) {
                            msg.append("    The following attached artifacts have been replaced with the baseline version: ");
                            msg.append(((Object)replaced).toString());
                            msg.append("\n");
                        }
                        if (!removed.isEmpty()) {
                            msg.append("    The following attached artifacts are not present in the baseline and have been removed: ");
                            msg.append(((Object)removed).toString());
                            msg.append("\n");
                        }
                        this.log.info(msg.toString());
                    }
                }
            } else {
                this.log.info("No baseline version " + project);
            }
        }
        return result;
    }

    private boolean isMissingOnlyDelta(ArtifactDelta delta) {
        if (delta instanceof MissingArtifactDelta) {
            return true;
        }
        if (delta instanceof CompoundArtifactDelta) {
            for (ArtifactDelta member : ((CompoundArtifactDelta)delta).getMembers().values()) {
                if (member instanceof MissingArtifactDelta) continue;
                return false;
            }
        }
        return true;
    }

    private CompoundArtifactDelta getDelta(BaselineService baselineService, Map<String, IP2Artifact> baselineMetadata, Map<String, IP2Artifact> generatedMetadata, ArtifactComparator.ComparisonData data) throws IOException {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry<String, IP2Artifact> classifierEntry : generatedMetadata.entrySet()) {
            String classifier = classifierEntry.getKey();
            Object deltaKey = classifier != null ? "classifier-" + classifier : "no-classifier";
            IP2Artifact baselineArtifact = baselineMetadata.get(classifier);
            IP2Artifact reactorArtifact = classifierEntry.getValue();
            if (baselineArtifact == null) {
                result.put(deltaKey, new MissingArtifactDelta());
                continue;
            }
            if (!baselineService.isMetadataEqual(baselineArtifact, reactorArtifact)) {
                result.put(deltaKey, new SimpleArtifactDelta("p2 metadata different"));
                continue;
            }
            try {
                ArtifactDelta delta = this.zipComparator.getDelta(baselineArtifact.getLocation(), reactorArtifact.getLocation(), data);
                if (delta == null) continue;
                result.put(deltaKey, delta);
            }
            catch (IOException e) {
                this.log.warn("Elementwise comparison of zip-file failed", (Throwable)e);
                if (FileUtils.contentEquals((File)baselineArtifact.getLocation(), (File)reactorArtifact.getLocation())) continue;
                result.put(deltaKey, new SimpleArtifactDelta("different"));
            }
        }
        return !result.isEmpty() ? new CompoundArtifactDelta("baseline and build artifacts have same version but different contents", result) : null;
    }

    private static class MissingArtifactDelta
    implements ArtifactDelta {
        private MissingArtifactDelta() {
        }

        public String getMessage() {
            return "not present in baseline";
        }

        public String getDetailedMessage() {
            return this.getMessage();
        }

        public void writeDetails(File destination) throws IOException {
        }
    }
}

