/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.p2.tools.P2DependencyTreeGenerator;

@Mojo(name="dependency-tree", requiresProject=true, threadSafe=true, requiresDependencyCollection=ResolutionScope.TEST)
public class DependenciesTreeMojo
extends AbstractMojo {
    @Parameter(property="project")
    private MavenProject project;
    @Component
    private P2DependencyTreeGenerator generator;
    @Component
    private TychoProjectManager projectManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List dependencyTree;
        Optional tychoProject = this.projectManager.getTychoProject(this.project);
        if (tychoProject.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)this.project.getId());
        List artifacts = ((TychoProject)tychoProject.get()).getDependencyArtifacts(DefaultReactorProject.adapt((MavenProject)this.project)).getArtifacts();
        Map<IInstallableUnit, Set<ReactorProject>> projectMap = artifacts.stream().filter(a -> a.getMavenProject() != null).flatMap(a -> a.getInstallableUnits().stream().map(iu -> new AbstractMap.SimpleEntry<IInstallableUnit, ReactorProject>((IInstallableUnit)iu, a.getMavenProject()))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
        HashSet unmapped = new HashSet();
        try {
            dependencyTree = this.generator.buildDependencyTree(this.project, unmapped);
        }
        catch (CoreException e) {
            throw new MojoFailureException((Throwable)e);
        }
        for (P2DependencyTreeGenerator.DependencyTreeNode rootNode : dependencyTree) {
            this.printUnit(rootNode, projectMap, 0);
        }
        if (!unmapped.isEmpty()) {
            this.getLog().info((CharSequence)"Units that cannot be matched to any requirement:");
            for (IInstallableUnit unit : unmapped) {
                this.getLog().info((CharSequence)unit.toString());
            }
        }
    }

    private void printUnit(P2DependencyTreeGenerator.DependencyTreeNode model, Map<IInstallableUnit, Set<ReactorProject>> projectMap, int indent) {
        Set<ReactorProject> mappedProjects;
        IInstallableUnit unit = model.getInstallableUnit();
        IRequirement satisfies = model.getRequirement();
        StringBuffer line = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            line.append("   ");
        }
        line.append("+- ");
        line.append(unit.getId());
        line.append(" (");
        line.append(unit.getVersion());
        line.append(")");
        if (satisfies != null) {
            line.append(" satisfies ");
            line.append(satisfies);
        }
        if ((mappedProjects = projectMap.get(unit)) != null && !mappedProjects.isEmpty()) {
            line.append(" --> ");
            line.append(mappedProjects.stream().map(ReactorProject::getId).sorted().collect(Collectors.joining(", ", "[", "]")));
        }
        this.getLog().info((CharSequence)line.toString());
        for (P2DependencyTreeGenerator.DependencyTreeNode child : model.getChildren()) {
            this.printUnit(child, projectMap, indent + 1);
        }
    }
}

