/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.SingleResponseValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.locking.facade.FileLocker;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.Launcher;
import org.eclipse.tycho.model.PluginRef;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherService;
import org.eclipse.tycho.plugins.p2.publisher.AbstractPublishMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="publish-products", defaultPhase=LifecyclePhase.PACKAGE)
public final class PublishProductMojo
extends AbstractPublishMojo {
    @Parameter(defaultValue="tooling")
    private String flavor;
    @Component(role=UnArchiver.class, hint="zip")
    private UnArchiver deflater;
    @Component
    private FileLockService fileLockService;

    @Override
    protected Collection<DependencySeed> publishContent(PublisherService publisherService) throws MojoExecutionException, MojoFailureException {
        ArrayList<DependencySeed> result = new ArrayList<DependencySeed>();
        for (File producFile : this.getEclipseRepositoryProject().getProductFiles(this.getProject())) {
            try {
                ProductConfiguration productConfiguration = ProductConfiguration.read((File)producFile);
                if (productConfiguration.getId() == null) {
                    throw new MojoExecutionException("The product file " + producFile.getName() + " does not contain the mandatory attribute 'uid'");
                }
                PublishProductMojo.qualifyVersions(productConfiguration, this.getQualifier());
                PublishProductMojo.interpolateProperties(productConfiguration, this.newInterpolator());
                PublishProductMojo.extractRootFeatures(productConfiguration, result);
                File preparedProductFile = PublishProductMojo.writeProductForPublishing(producFile, productConfiguration, this.getBuildDirectory());
                Collection seeds = publisherService.publishProduct(preparedProductFile, productConfiguration.includeLaunchers() ? this.getEquinoxExecutableFeature() : null, this.flavor);
                result.addAll(seeds);
            }
            catch (FacadeException e) {
                throw new MojoExecutionException("Exception while publishing product " + producFile.getAbsolutePath(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("I/O exception while writing product definition or copying launcher icons", (Exception)e);
            }
        }
        return result;
    }

    static File writeProductForPublishing(File originalProductFile, ProductConfiguration productConfiguration, BuildOutputDirectory targetDir) throws IOException {
        File buildProductDir = targetDir.getChild("products/" + productConfiguration.getId());
        buildProductDir.mkdirs();
        File preparedProductFile = new File(buildProductDir, originalProductFile.getName());
        ProductConfiguration.write((ProductConfiguration)productConfiguration, (File)preparedProductFile);
        PublishProductMojo.copyP2Inf(PublishProductMojo.getSourceP2InfFile(originalProductFile), new File(buildProductDir, "p2.inf"));
        PublishProductMojo.copyReferencedFiles(productConfiguration, originalProductFile.getParentFile(), buildProductDir);
        return preparedProductFile;
    }

    private static void copyReferencedFiles(ProductConfiguration productConfiguration, File sourceDir, File targetDir) throws IOException {
        ProductConfiguration.ConfigIni configIni;
        Launcher launcher = productConfiguration.getLauncher();
        ArrayList<String> relativePaths = new ArrayList<String>();
        if (launcher != null) {
            relativePaths.addAll(launcher.getLinuxIcon().values());
            relativePaths.addAll(launcher.getWindowsIcon().values());
            relativePaths.addAll(launcher.getSolarisIcon().values());
            relativePaths.addAll(launcher.getMacosxIcon().values());
        }
        if ((configIni = productConfiguration.getConfigIni()) != null) {
            relativePaths.add(configIni.getLinuxConfigIni());
            relativePaths.add(configIni.getWin32ConfigIni());
            relativePaths.add(configIni.getSolarisConfigIni());
            relativePaths.add(configIni.getMacosxConfigIni());
        }
        PublishProductMojo.copyFiles(sourceDir, targetDir, relativePaths);
    }

    private static void copyFiles(File sourceDir, File targetDir, List<String> relativePaths) throws IOException {
        for (String relativePath : relativePaths) {
            File sourceFile;
            if (relativePath == null || !(sourceFile = new File(sourceDir, relativePath)).isFile()) continue;
            FileUtils.copyFile((File)sourceFile, (File)new File(targetDir, relativePath));
        }
    }

    static void copyP2Inf(File sourceP2Inf, File buildP2Inf) throws IOException {
        if (sourceP2Inf.exists()) {
            FileUtils.copyFile((File)sourceP2Inf, (File)buildP2Inf);
        }
    }

    static File getSourceP2InfFile(File productFile) {
        String productFileName = productFile.getName();
        String p2infFilename = productFileName.substring(0, productFileName.length() - ".product".length()) + ".p2.inf";
        return new File(productFile.getParentFile(), p2infFilename);
    }

    static void qualifyVersions(ProductConfiguration productConfiguration, String buildQualifier) {
        String newVersion;
        String productVersion = productConfiguration.getVersion();
        if (productVersion != null) {
            productVersion = PublishProductMojo.replaceQualifier(productVersion, buildQualifier);
            productConfiguration.setVersion(productVersion);
        }
        for (FeatureRef featRef : productConfiguration.getFeatures()) {
            if (featRef.getVersion() == null || !featRef.getVersion().endsWith("qualifier")) continue;
            newVersion = PublishProductMojo.replaceQualifier(featRef.getVersion(), buildQualifier);
            featRef.setVersion(newVersion);
        }
        for (PluginRef plugRef : productConfiguration.getPlugins()) {
            if (plugRef.getVersion() == null || !plugRef.getVersion().endsWith("qualifier")) continue;
            newVersion = PublishProductMojo.replaceQualifier(plugRef.getVersion(), buildQualifier);
            plugRef.setVersion(newVersion);
        }
    }

    private static String replaceQualifier(String productVersion, String qualifier) {
        String replaceVersion = productVersion;
        if (productVersion.endsWith(".qualifier")) {
            int qualifierIndex = productVersion.length() - "qualifier".length();
            String unqualifiedVersion = productVersion.substring(0, qualifierIndex - 1);
            replaceVersion = qualifier == null || "".equals(qualifier) ? unqualifiedVersion : unqualifiedVersion + "." + qualifier;
        }
        return replaceVersion;
    }

    private static void interpolateProperties(ProductConfiguration productConfiguration, Interpolator interpolator) throws MojoExecutionException {
        List properties = productConfiguration.getConfigurationProperties();
        if (properties != null && interpolator != null) {
            for (ProductConfiguration.ConfigurationProperty property : properties) {
                try {
                    property.setValue(interpolator.interpolate(property.getValue()));
                }
                catch (InterpolationException e) {
                    throw new MojoExecutionException("Could not interpolate product configuration property " + property.getName(), (Exception)((Object)e));
                }
            }
        }
    }

    static void extractRootFeatures(ProductConfiguration product, List<DependencySeed> seeds) {
        final String productId = product.getId();
        DependencySeed.Filter filter = new DependencySeed.Filter(){

            public boolean isAddOnFor(String type, String id) {
                return "eclipse-product".equals(type) && productId.equals(id);
            }
        };
        for (FeatureRef feature : product.getFeatures()) {
            if (feature.getInstallMode() != FeatureRef.InstallMode.root) continue;
            seeds.add(new DependencySeed("eclipse-feature", feature.getId(), null, filter));
        }
        product.removeRootInstalledFeatures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getEquinoxExecutableFeature() throws MojoExecutionException, MojoFailureException {
        File file;
        DependencyArtifacts dependencyArtifacts = TychoProjectUtils.getDependencyArtifacts((MavenProject)this.getProject());
        ArtifactDescriptor artifact = dependencyArtifacts.getArtifact("eclipse-feature", "org.eclipse.equinox.executable", null);
        if (artifact == null) {
            throw new MojoExecutionException("Unable to locate the equinox launcher feature (aka delta-pack)");
        }
        File equinoxExecFeature = artifact.getLocation();
        if (equinoxExecFeature.isDirectory()) {
            return equinoxExecFeature.getAbsoluteFile();
        }
        File unzipped = new File(this.getProject().getBuild().getOutputDirectory(), artifact.getKey().getId() + "-" + artifact.getKey().getVersion());
        if (unzipped.exists()) {
            return unzipped.getAbsoluteFile();
        }
        FileLocker locker = this.fileLockService.getFileLocker(equinoxExecFeature);
        locker.lock();
        try {
            unzipped.mkdirs();
            this.deflater.setSourceFile(equinoxExecFeature);
            this.deflater.setDestDirectory(unzipped);
            this.deflater.extract();
            file = unzipped.getAbsoluteFile();
        }
        catch (Throwable throwable) {
            try {
                locker.release();
                throw throwable;
            }
            catch (ArchiverException e) {
                throw new MojoFailureException("Unable to unzip the eqiuinox executable feature", (Throwable)e);
            }
        }
        locker.release();
        return file;
    }

    protected Interpolator newInterpolator() {
        MavenProject mavenProject = this.getProject();
        MavenSession mavenSession = this.getSession();
        final Properties baseProps = new Properties();
        baseProps.putAll((Map<?, ?>)mavenProject.getProperties());
        baseProps.putAll((Map<?, ?>)mavenSession.getSystemProperties());
        baseProps.putAll((Map<?, ?>)mavenSession.getUserProperties());
        Settings settings = mavenSession.getSettings();
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("project", (Object)mavenProject));
        interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("settings", (Object)settings));
        interpolator.addValueSource((ValueSource)new SingleResponseValueSource("localRepository", (Object)settings.getLocalRepository()));
        interpolator.addValueSource(new ValueSource(){

            public Object getValue(String expression) {
                return baseProps.getProperty(expression);
            }

            public void clearFeedback() {
            }

            public List getFeedback() {
                return Collections.EMPTY_LIST;
            }
        });
        return interpolator;
    }
}

