/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher;

import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.EclipseRepositoryProject;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.osgi.adapters.MavenReactorProjectIdentities;
import org.eclipse.tycho.p2.tools.BuildContext;

public abstract class AbstractP2Mojo
extends AbstractMojo {
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(property="buildQualifier", readonly=true)
    private String qualifier;

    protected MavenProject getProject() {
        return this.project;
    }

    protected ReactorProjectIdentities getProjectIdentities() {
        return new MavenReactorProjectIdentities(this.project);
    }

    protected MavenSession getSession() {
        return this.session;
    }

    protected String getQualifier() {
        return this.qualifier;
    }

    protected BuildOutputDirectory getBuildDirectory() {
        return this.getProjectIdentities().getBuildDirectory();
    }

    protected EclipseRepositoryProject getEclipseRepositoryProject() {
        return (EclipseRepositoryProject)this.getTychoProjectFacet("eclipse-repository");
    }

    private TychoProject getTychoProjectFacet(String packaging) {
        TychoProject facet;
        try {
            facet = (TychoProject)this.session.lookup(TychoProject.class.getName(), packaging);
        }
        catch (ComponentLookupException e) {
            throw new IllegalStateException("Could not lookup required component", e);
        }
        return facet;
    }

    protected BuildContext getBuildContext() {
        List environments = TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)this.project).getEnvironments();
        return new BuildContext(this.getProjectIdentities(), this.getQualifier(), environments);
    }
}

