/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher;

import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.p2.facade.RepositoryReferenceTool;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherService;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherServiceFactory;
import org.eclipse.tycho.plugins.p2.publisher.AbstractP2Mojo;

public abstract class AbstractPublishMojo
extends AbstractP2Mojo {
    @Component
    private RepositoryReferenceTool repositoryReferenceTool;
    @Component
    private EquinoxServiceFactory osgiServices;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        PublisherService publisherService = this.createPublisherService();
        Collection<DependencySeed> units = this.publishContent(publisherService);
        this.postPublishedIUs(units);
    }

    protected abstract Collection<DependencySeed> publishContent(PublisherService var1) throws MojoExecutionException, MojoFailureException;

    private PublisherService createPublisherService() throws MojoExecutionException, MojoFailureException {
        try {
            RepositoryReferences contextRepositories = this.repositoryReferenceTool.getVisibleRepositories(this.getProject(), this.getSession(), 0);
            PublisherServiceFactory publisherServiceFactory = (PublisherServiceFactory)this.osgiServices.getService(PublisherServiceFactory.class);
            return publisherServiceFactory.createPublisher(contextRepositories, this.getBuildContext());
        }
        catch (FacadeException e) {
            throw new MojoExecutionException("Exception while initializing the publisher service", (Exception)((Object)e));
        }
    }

    private void postPublishedIUs(Collection<DependencySeed> units) {
        TychoProjectUtils.getDependencySeeds((MavenProject)this.getProject()).addAll(units);
    }
}

