/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.core.maven.TychoInterpolator;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;
import org.eclipse.tycho.core.shared.Interpolator;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.locking.facade.FileLocker;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.p2.tools.publisher.facade.PublishProductTool;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherServiceFactory;
import org.eclipse.tycho.plugins.p2.publisher.AbstractPublishMojo;

@Mojo(name="publish-products", defaultPhase=LifecyclePhase.PACKAGE)
public final class PublishProductMojo
extends AbstractPublishMojo {
    @Deprecated
    @Parameter(defaultValue="tooling")
    private String flavor;
    @Component(role=UnArchiver.class, hint="zip")
    private UnArchiver deflater;
    @Component
    private FileLockService fileLockService;

    @Override
    protected Collection<DependencySeed> publishContent(PublisherServiceFactory publisherServiceFactory) throws MojoExecutionException, MojoFailureException {
        TychoInterpolator interpolator = new TychoInterpolator(this.getSession(), this.getProject());
        PublishProductTool publisher = publisherServiceFactory.createProductPublisher(this.getReactorProject(), this.getEnvironments(), this.getQualifier(), (Interpolator)interpolator);
        ArrayList<DependencySeed> seeds = new ArrayList<DependencySeed>();
        for (File productFile : this.getEclipseRepositoryProject().getProductFiles(this.getProject())) {
            try {
                ProductConfiguration productConfiguration = ProductConfiguration.read((File)productFile);
                if (StringUtils.isEmpty((CharSequence)productConfiguration.getId())) {
                    throw new MojoExecutionException("The product file " + productFile.getName() + " does not contain the mandatory attribute 'uid'");
                }
                if (StringUtils.isEmpty((CharSequence)productConfiguration.getVersion())) {
                    throw new MojoExecutionException("The product file " + productFile.getName() + " does not contain the mandatory attribute 'version'");
                }
                seeds.addAll(publisher.publishProduct(productFile, productConfiguration.includeLaunchers() ? this.getExpandedLauncherBinaries() : null, this.flavor));
            }
            catch (IOException e) {
                throw new MojoExecutionException("I/O exception while writing product definition or copying launcher icons", (Exception)e);
            }
        }
        return seeds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getExpandedLauncherBinaries() throws MojoExecutionException, MojoFailureException {
        File file;
        DependencyArtifacts dependencyArtifacts = TychoProjectUtils.getDependencyArtifacts((MavenProject)this.getProject());
        ArtifactDescriptor artifact = dependencyArtifacts.getArtifact("eclipse-feature", "org.eclipse.equinox.executable", null);
        if (artifact == null) {
            throw new MojoExecutionException("Unable to locate the equinox launcher feature (aka delta-pack)");
        }
        File equinoxExecFeature = artifact.getLocation();
        if (equinoxExecFeature.isDirectory()) {
            return equinoxExecFeature.getAbsoluteFile();
        }
        File unzipped = new File(this.getProject().getBuild().getDirectory(), artifact.getKey().getId() + "-" + artifact.getKey().getVersion());
        if (unzipped.exists()) {
            return unzipped.getAbsoluteFile();
        }
        FileLocker locker = this.fileLockService.getFileLocker(equinoxExecFeature);
        locker.lock();
        try {
            unzipped.mkdirs();
            this.deflater.setSourceFile(equinoxExecFeature);
            this.deflater.setDestDirectory(unzipped);
            this.deflater.extract();
            file = unzipped.getAbsoluteFile();
        }
        catch (Throwable throwable) {
            try {
                locker.release();
                throw throwable;
            }
            catch (ArchiverException e) {
                throw new MojoFailureException("Unable to unzip the eqiuinox executable feature", (Throwable)e);
            }
        }
        locker.release();
        return file;
    }
}

