/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherService;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherServiceFactory;
import org.eclipse.tycho.plugins.p2.publisher.AbstractPublishMojo;

@Mojo(name="publish-osgi-ee", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public final class PublishOsgiEEMojo
extends AbstractPublishMojo {
    @Parameter(defaultValue="JavaSE-10, JavaSE-11")
    private String profiles;
    @Parameter(defaultValue="false")
    private boolean skip;

    @Override
    protected Collection<DependencySeed> publishContent(PublisherServiceFactory publisherServiceFactory) throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return Collections.emptyList();
        }
        PublisherService publisherService = publisherServiceFactory.createPublisher(this.getReactorProject(), this.getEnvironments());
        ArrayList<DependencySeed> result = new ArrayList<DependencySeed>();
        for (String profile : this.profiles.split(",")) {
            try {
                profile = profile.trim();
                if ("".equals(profile)) continue;
                Collection ius = publisherService.publishEEProfile(profile);
                this.getLog().info((CharSequence)("Published profile IUs: " + ius));
                result.addAll(ius);
            }
            catch (FacadeException e) {
                throw new MojoExecutionException("Exception while publishing execution environment profile " + profile + ": " + e.getMessage(), (Exception)((Object)e));
            }
        }
        return result;
    }
}

