/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.maven.TychoInterpolator;
import org.eclipse.tycho.core.osgitools.EclipseRepositoryProject;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;
import org.eclipse.tycho.core.shared.Interpolator;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.locking.facade.FileLocker;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.p2.tools.publisher.facade.PublishProductTool;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherServiceFactory;
import org.eclipse.tycho.plugins.p2.publisher.AbstractPublishMojo;
import org.osgi.framework.Version;

@Mojo(name="publish-products", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public final class PublishProductMojo
extends AbstractPublishMojo {
    private static final Version LUNA_SR2_EXECUTABLE_FEATURE_VERSION = Version.parseVersion((String)"3.6.102.v20150204-1316");
    @Deprecated
    @Parameter(defaultValue="tooling")
    private String flavor;
    @Component(role=UnArchiver.class, hint="zip")
    private UnArchiver deflater;
    @Component
    private FileLockService fileLockService;
    @Component(role=TychoProject.class, hint="eclipse-repository")
    private EclipseRepositoryProject eclipseRepositoryProject;

    @Override
    protected Collection<DependencySeed> publishContent(PublisherServiceFactory publisherServiceFactory) throws MojoExecutionException, MojoFailureException {
        TychoInterpolator interpolator = new TychoInterpolator(this.getSession(), this.getProject());
        PublishProductTool publisher = publisherServiceFactory.createProductPublisher(this.getReactorProject(), this.getEnvironments(), this.getQualifier(), (Interpolator)interpolator);
        ArrayList<DependencySeed> seeds = new ArrayList<DependencySeed>();
        for (File productFile : this.eclipseRepositoryProject.getProductFiles(this.getProject())) {
            try {
                ProductConfiguration productConfiguration = ProductConfiguration.read((File)productFile);
                if (productConfiguration.getId().isEmpty()) {
                    throw new MojoExecutionException("The product file " + productFile.getName() + " does not contain the mandatory attribute 'uid'. Please ensure you entered an id in the product file.");
                }
                if (productConfiguration.getVersion().isEmpty()) {
                    throw new MojoExecutionException("The product file " + productFile.getName() + " does not contain the mandatory attribute 'version'. Please ensure you entered a version in the product file.");
                }
                seeds.addAll(publisher.publishProduct(productFile, productConfiguration.includeLaunchers() ? this.getExpandedLauncherBinaries() : null, this.flavor));
            }
            catch (IOException e) {
                throw new MojoExecutionException("I/O exception while writing product definition or copying launcher icons", (Exception)e);
            }
        }
        return seeds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getExpandedLauncherBinaries() throws MojoExecutionException, MojoFailureException {
        File file;
        DependencyArtifacts dependencyArtifacts = TychoProjectUtils.getDependencyArtifacts((MavenProject)this.getProject());
        ArtifactDescriptor artifact = dependencyArtifacts.getArtifact("eclipse-feature", "org.eclipse.equinox.executable", null);
        if (artifact == null) {
            throw new MojoExecutionException("Unable to locate feature 'org.eclipse.equinox.executable'. This feature is required for native product launchers.");
        }
        this.checkMacOSLauncherCompatibility(artifact);
        File equinoxExecFeature = artifact.getLocation();
        if (equinoxExecFeature.isDirectory()) {
            return equinoxExecFeature.getAbsoluteFile();
        }
        File unzipped = new File(this.getProject().getBuild().getDirectory(), artifact.getKey().getId() + "-" + artifact.getKey().getVersion());
        if (unzipped.exists()) {
            return unzipped.getAbsoluteFile();
        }
        FileLocker locker = this.fileLockService.getFileLocker(equinoxExecFeature);
        locker.lock();
        try {
            unzipped.mkdirs();
            this.deflater.setSourceFile(equinoxExecFeature);
            this.deflater.setDestDirectory(unzipped);
            this.deflater.extract();
            file = unzipped.getAbsoluteFile();
        }
        catch (Throwable throwable) {
            try {
                locker.release();
                throw throwable;
            }
            catch (ArchiverException e) {
                throw new MojoFailureException("Unable to unzip the equinox executable feature", (Throwable)e);
            }
        }
        locker.release();
        return file;
    }

    private void checkMacOSLauncherCompatibility(ArtifactDescriptor executablesFeature) throws MojoExecutionException {
        if (!this.macOSConfigured()) {
            return;
        }
        Version featureVersion = Version.parseVersion((String)executablesFeature.getKey().getVersion());
        if (PublishProductMojo.isLunaOrOlder(featureVersion)) {
            throw new MojoExecutionException("Detected Luna or older launcher feature org.eclipse.equinox.executable version " + featureVersion + ".\n Native product launchers for MacOSX can only be built against Eclipse Mars or newer.\nTo fix this, you can either build against Eclipse Mars or newer (recommended) or go back to Tycho <= 0.22.0");
        }
    }

    static boolean isLunaOrOlder(Version featureVersion) {
        return featureVersion.compareTo(LUNA_SR2_EXECUTABLE_FEATURE_VERSION) <= 0;
    }

    private boolean macOSConfigured() {
        for (TargetEnvironment env : this.getEnvironments()) {
            if (!"macosx".equals(env.getOs())) continue;
            return true;
        }
        return false;
    }
}

