/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentUtils;
import org.eclipse.tycho.core.ee.StandardExecutionEnvironment;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironment;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherService;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherServiceFactory;
import org.eclipse.tycho.plugins.p2.publisher.AbstractPublishMojo;

@Mojo(name="publish-osgi-ee", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public final class PublishOsgiEEMojo
extends AbstractPublishMojo {
    @Parameter(defaultValue="JavaSE-11, JavaSE-14, JavaSE-15, JavaSE-16")
    private String profiles;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private Logger logger;

    @Override
    protected Collection<DependencySeed> publishContent(PublisherServiceFactory publisherServiceFactory) throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return Collections.emptyList();
        }
        PublisherService publisherService = publisherServiceFactory.createPublisher(this.getReactorProject(), this.getEnvironments());
        ArrayList<DependencySeed> result = new ArrayList<DependencySeed>();
        for (String profile : this.profiles.split(",")) {
            try {
                profile = profile.trim();
                if (profile.isEmpty()) continue;
                StandardExecutionEnvironment ee = ExecutionEnvironmentUtils.getExecutionEnvironment((String)profile, (ToolchainManager)this.toolchainManager, (MavenSession)this.getSession(), (Logger)this.logger);
                Collection ius = publisherService.publishEEProfile((ExecutionEnvironment)ee);
                this.getLog().info((CharSequence)("Published profile IUs: " + ius));
                result.addAll(ius);
            }
            catch (FacadeException e) {
                throw new MojoExecutionException("Exception while publishing execution environment profile " + profile + ": " + e.getMessage(), (Exception)((Object)e));
            }
        }
        return result;
    }
}

