/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher.persistence;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.maven.AbstractP2Mojo;
import org.eclipse.tycho.repository.registry.facade.PublishingRepositoryFacade;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManagerFacade;

@Mojo(name="attach-artifacts", threadSafe=true)
public class AttachPublishedArtifactsMojo
extends AbstractP2Mojo {
    private static final Object LOCK = new Object();
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private EquinoxServiceFactory osgiServices;
    @Component
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object object = LOCK;
        synchronized (object) {
            ReactorRepositoryManagerFacade reactorRepoManager = (ReactorRepositoryManagerFacade)this.osgiServices.getService(ReactorRepositoryManagerFacade.class);
            PublishingRepositoryFacade publishingRepo = reactorRepoManager.getPublishingRepository(this.getProjectIdentities());
            Map artifacts = publishingRepo.getArtifactLocations();
            for (Map.Entry entry : artifacts.entrySet()) {
                String classifier = (String)entry.getKey();
                File artifactLocation = (File)entry.getValue();
                if (classifier == null) {
                    this.getProject().getArtifact().setFile(artifactLocation);
                    continue;
                }
                String type = AttachPublishedArtifactsMojo.getExtension(artifactLocation);
                this.projectHelper.attachArtifact(this.getProject(), type, classifier, artifactLocation);
                this.logger.debug("Attaching " + type + "::" + classifier + " -> " + artifactLocation);
            }
            ReactorProject reactorProject = this.getReactorProject();
            reactorProject.setDependencyMetadata(true, publishingRepo.getInstallableUnits());
            reactorProject.setDependencyMetadata(false, Collections.emptySet());
        }
    }

    private static String getExtension(File file) {
        String fileName = file.getName();
        int separator = fileName.lastIndexOf(46);
        if (separator < 0) {
            throw new IllegalArgumentException("No file extension in \"" + fileName + "\"");
        }
        return fileName.substring(separator + 1);
    }
}

