/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.core.osgitools.EclipseRepositoryProject;
import org.eclipse.tycho.p2maven.InstallableUnitGenerator;
import org.eclipse.tycho.p2maven.actions.ProductFile2;
import org.eclipse.tycho.resolver.InstallableUnitProvider;

@Component(role=InstallableUnitProvider.class, hint="publish-products")
public class PublishProductInstallableUnitProvider
implements InstallableUnitProvider {
    static final String HINT = "publish-products";
    @Requirement
    private InstallableUnitGenerator installableUnitGenerator;

    public Collection<IInstallableUnit> getInstallableUnits(MavenProject project, MavenSession session) throws CoreException {
        return PublishProductInstallableUnitProvider.getProductUnits(this.installableUnitGenerator, project);
    }

    static Set<IInstallableUnit> getProductUnits(InstallableUnitGenerator installableUnitGenerator, MavenProject project) {
        if ("eclipse-repository".equals(project.getPackaging())) {
            return Set.of();
        }
        Plugin plugin = project.getPlugin("org.eclipse.tycho:tycho-p2-publisher-plugin");
        if (plugin == null || plugin.getExecutions().isEmpty()) {
            return Set.of();
        }
        List productFiles = EclipseRepositoryProject.getProductFiles((File)project.getBasedir());
        if (productFiles.isEmpty()) {
            return Set.of();
        }
        ArrayList requirements = new ArrayList();
        for (File file : productFiles) {
            try {
                Collection units = installableUnitGenerator.getInstallableUnits((IProductDescriptor)new ProductFile2(file));
                for (IInstallableUnit unit : units) {
                    requirements.addAll(unit.getRequirements());
                }
            }
            catch (CoreException coreException) {
            }
            catch (Exception exception) {
            }
        }
        if (requirements.isEmpty()) {
            return Set.of();
        }
        return new HashSet<IInstallableUnit>(InstallableUnitProvider.createIU(requirements, (String)HINT));
    }
}

