/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.p2.facade.RepositoryReferenceTool;
import org.eclipse.tycho.p2.tools.DestinationRepositoryDescriptor;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.plugins.p2.repository.AbstractRepositoryMojo;

@Mojo(name="assemble-repository", defaultPhase=LifecyclePhase.PACKAGE)
public class AssembleRepositoryMojo
extends AbstractRepositoryMojo {
    @Parameter(defaultValue="true")
    private boolean createArtifactRepository;
    @Parameter(defaultValue="false")
    private boolean includeAllDependencies;
    @Parameter(defaultValue="true")
    private boolean compress;
    @Parameter(defaultValue="${project.name}")
    private String repositoryName;
    @Parameter
    private Map<String, String> profileProperties;
    @Component
    private RepositoryReferenceTool repositoryReferenceTool;
    @Component
    private EquinoxServiceFactory p2;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File destination = this.getAssemblyRepositoryLocation();
            destination.mkdirs();
            List projectSeeds = TychoProjectUtils.getDependencySeeds((MavenProject)this.getProject());
            if (projectSeeds.size() == 0) {
                throw new MojoFailureException("No content specified for p2 repository");
            }
            RepositoryReferences sources = this.getVisibleRepositories();
            TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)this.getProject());
            MirrorApplicationService mirrorApp = (MirrorApplicationService)this.p2.getService(MirrorApplicationService.class);
            DestinationRepositoryDescriptor destinationRepoDescriptor = new DestinationRepositoryDescriptor(destination, this.repositoryName, this.compress, !this.createArtifactRepository, true);
            mirrorApp.mirrorReactor(sources, destinationRepoDescriptor, (Collection)projectSeeds, this.getBuildContext(), this.includeAllDependencies, configuration.isIncludePackedArtifacts(), this.profileProperties);
        }
        catch (FacadeException e) {
            throw new MojoExecutionException("Could not assemble p2 repository", (Exception)((Object)e));
        }
    }

    protected RepositoryReferences getVisibleRepositories() throws MojoExecutionException, MojoFailureException {
        int flags = RepositoryReferenceTool.REPOSITORIES_INCLUDE_CURRENT_MODULE;
        return this.repositoryReferenceTool.getVisibleRepositories(this.getProject(), this.getSession(), flags);
    }
}

