/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.File;
import java.net.URI;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.core.maven.AbstractP2Mojo;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.verifier.facade.VerifierService;

@Mojo(name="verify-repository", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class VerifyIntegrityRepositoryMojo
extends AbstractP2Mojo
implements LogEnabled {
    private static final Object LOCK = new Object();
    private Logger logger;
    @Component(hint="tycho-core")
    private EquinoxServiceFactory p2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object object = LOCK;
        synchronized (object) {
            File repositoryDir = this.getBuildDirectory().getChild("repository");
            this.logger.info("Verifying p2 repositories in " + repositoryDir);
            VerifierService verifier = (VerifierService)this.p2.getService(VerifierService.class);
            URI repositoryUri = repositoryDir.toURI();
            try {
                if (!verifier.verify(repositoryUri, repositoryUri, this.getBuildDirectory())) {
                    throw new MojoFailureException("The repository is invalid.");
                }
            }
            catch (FacadeException e) {
                throw new MojoExecutionException("Verification failed", (Exception)((Object)e));
            }
        }
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

