/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.EclipseRepositoryProject;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.model.Category;
import org.eclipse.tycho.p2.facade.RepositoryReferenceTool;
import org.eclipse.tycho.p2.tools.DestinationRepositoryDescriptor;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReference;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.plugins.p2.repository.AbstractRepositoryMojo;

@Mojo(name="assemble-repository", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class AssembleRepositoryMojo
extends AbstractRepositoryMojo {
    private static final Object LOCK = new Object();
    @Parameter(defaultValue="true")
    private boolean createArtifactRepository;
    @Parameter(defaultValue="false")
    private boolean includeAllDependencies;
    @Parameter(defaultValue="false")
    private boolean includeAllSources;
    @Parameter(defaultValue="false")
    private boolean includeRequiredPlugins;
    @Parameter(defaultValue="false")
    private boolean includeRequiredFeatures;
    @Parameter(defaultValue="true")
    private boolean compress;
    @Parameter(defaultValue="true")
    private boolean xzCompress;
    @Parameter(defaultValue="true")
    private boolean keepNonXzIndexFiles;
    @Parameter(defaultValue="${project.name}")
    private String repositoryName;
    @Parameter
    private Map<String, String> profileProperties;
    @Parameter
    private Map<String, String> extraArtifactRepositoryProperties;
    @Component
    private RepositoryReferenceTool repositoryReferenceTool;
    @Component(hint="tycho-core")
    private EquinoxServiceFactory p2;
    @Component(role=TychoProject.class, hint="eclipse-repository")
    private EclipseRepositoryProject eclipseRepositoryProject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object object = LOCK;
        synchronized (object) {
            try {
                File destination = this.getAssemblyRepositoryLocation();
                destination.mkdirs();
                this.copyResources(destination);
                List projectSeeds = TychoProjectUtils.getDependencySeeds((ReactorProject)this.getReactorProject());
                if (projectSeeds.isEmpty()) {
                    this.getLog().warn((CharSequence)"No content specified for p2 repository");
                    return;
                }
                RepositoryReferences sources = this.getVisibleRepositories();
                MirrorApplicationService mirrorApp = (MirrorApplicationService)this.p2.getService(MirrorApplicationService.class);
                List repositoryRefrences = this.getCategories().stream().map(Category::getRepositoryReferences).flatMap(Collection::stream).map(ref -> new RepositoryReference(ref.getName(), ref.getLocation(), ref.isEnabled())).collect(Collectors.toList());
                DestinationRepositoryDescriptor destinationRepoDescriptor = new DestinationRepositoryDescriptor(destination, this.repositoryName, this.compress, this.xzCompress, this.keepNonXzIndexFiles, !this.createArtifactRepository, true, this.extraArtifactRepositoryProperties, repositoryRefrences);
                mirrorApp.mirrorReactor(sources, destinationRepoDescriptor, (Collection)projectSeeds, this.getBuildContext(), this.includeAllDependencies, this.includeAllSources, this.includeRequiredPlugins, this.includeRequiredFeatures, this.profileProperties);
            }
            catch (FacadeException e) {
                throw new MojoExecutionException("Could not assemble p2 repository", (Exception)((Object)e));
            }
        }
    }

    private void copyResources(File destination) throws MojoExecutionException {
        File outputDir = new File(this.getProject().getBuild().getOutputDirectory());
        try {
            if (outputDir.isDirectory()) {
                this.getLog().info((CharSequence)String.format("Copying resources from %s to %s", outputDir, destination));
                FileUtils.copyDirectoryStructure((File)outputDir, (File)destination);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying resources", (Exception)e);
        }
    }

    protected RepositoryReferences getVisibleRepositories() throws MojoExecutionException, MojoFailureException {
        int flags = RepositoryReferenceTool.REPOSITORIES_INCLUDE_CURRENT_MODULE;
        return this.repositoryReferenceTool.getVisibleRepositories(this.getProject(), this.getSession(), flags);
    }

    private List<Category> getCategories() {
        return this.eclipseRepositoryProject.loadCategories(this.getReactorProject());
    }
}

