/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.File;
import java.util.Collections;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.p2.tools.DestinationRepositoryDescriptor;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.plugins.p2.repository.AbstractRepositoryMojo;

@Mojo(name="fix-artifacts-metadata", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class FixArtifactsMetadataMetadataMojo
extends AbstractRepositoryMojo {
    private static final Object LOCK = new Object();
    @Parameter(defaultValue="${project.name}")
    private String repositoryName;
    @Parameter(defaultValue="true")
    private boolean xzCompress;
    @Parameter(defaultValue="true")
    private boolean keepNonXzIndexFiles;
    @Component(hint="tycho-core")
    private EquinoxServiceFactory p2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object object = LOCK;
        synchronized (object) {
            try {
                File destination = this.getAssemblyRepositoryLocation();
                if (!destination.isDirectory()) {
                    throw new MojoExecutionException("Could not update p2 repository, directory does not exist: " + destination);
                }
                MirrorApplicationService mirrorApp = (MirrorApplicationService)this.p2.getService(MirrorApplicationService.class);
                DestinationRepositoryDescriptor destinationRepoDescriptor = new DestinationRepositoryDescriptor(destination, this.repositoryName, true, this.xzCompress, this.keepNonXzIndexFiles, false, true, Collections.emptyMap(), Collections.emptyList());
                mirrorApp.recreateArtifactRepository(destinationRepoDescriptor);
            }
            catch (FacadeException e) {
                throw new MojoExecutionException("Could not update p2 repository", (Exception)((Object)e));
            }
        }
    }
}

