/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.eclipse.tycho.plugins.p2.repository.AbstractRepositoryMojo;

@Mojo(name="archive-repository", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public final class ArchiveRepositoryMojo
extends AbstractRepositoryMojo {
    private static final Object LOCK = new Object();
    @Component(role=Archiver.class, hint="zip")
    private Archiver inflater;
    @Parameter(property="project.build.finalName")
    private String finalName;
    @Parameter(defaultValue="false")
    private boolean skipArchive;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipArchive) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            File destFile = this.getBuildDirectory().getChild(this.finalName + ".zip");
            try {
                this.inflater.addFileSet((FileSet)DefaultFileSet.fileSet((File)this.getAssemblyRepositoryLocation()).prefixed(""));
                this.inflater.setDestFile(destFile);
                this.inflater.createArchive();
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error packing p2 repository", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error packing p2 repository", (Exception)e);
            }
            this.getProject().getArtifact().setFile(destFile);
        }
    }
}

