/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.tycho.ReproducibleUtils;
import org.eclipse.tycho.core.PGPService;
import org.eclipse.tycho.p2maven.tools.TychoFeaturesAndBundlesPublisherApplication;

@Mojo(name="assemble-maven-repository", requiresDependencyResolution=ResolutionScope.COMPILE)
public class MavenP2SiteMojo
extends AbstractMojo {
    private static final boolean INCLUDE_PGP_DEFAULT = false;
    private static final List<String> DEFAULT_KEY_SERVER = List.of("https://keyserver.ubuntu.com/pks/lookup?op=get&search={0}", "http://pgp.mit.edu/pks/lookup?op=get&search={0}");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="true")
    private boolean includeDependencies = true;
    @Parameter(defaultValue="false")
    private boolean includeManaged = false;
    @Parameter(defaultValue="false")
    private boolean includeReactor = false;
    @Parameter(defaultValue="false")
    private boolean includeTransitiveDependencies;
    @Parameter(defaultValue="300")
    private int timeoutInSeconds = 300;
    @Parameter(defaultValue="${project.basedir}/category.xml")
    private File categoryFile;
    @Parameter(defaultValue="Bundles")
    private String categoryName;
    @Parameter(defaultValue="${project.build.directory}/repository")
    private File destination;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Component
    private Logger logger;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private IProvisioningAgent agent;
    @Component
    private PGPService pgpService;
    @Parameter(property="project.build.directory", required=true)
    protected File buildDirectory;
    @Parameter
    private List<String> keyServerUrls;
    @Parameter(defaultValue="10")
    private int keyServerRetry = 10;
    @Parameter(defaultValue="false")
    private boolean includePGPSignature = false;
    @Parameter(property="mojoExecution", readonly=true)
    MojoExecution execution;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Object result;
        String categoryURI;
        this.agent.getService(IArtifactRepositoryManager.class);
        this.logger.debug("categoryName =        " + this.categoryName);
        this.logger.debug("includeDependencies = " + this.includeDependencies);
        this.logger.debug("includeManaged =      " + this.includeManaged);
        this.logger.debug("includeReactor =      " + this.includeReactor);
        this.logger.debug("includeTransitive =   " + this.includeTransitiveDependencies);
        List<String> keyServers = this.getKeyServers();
        if (this.includePGPSignature) {
            this.logger.debug("keyServerUrl =        " + keyServers.stream().collect(Collectors.joining(", ")));
            this.logger.debug("keyServerRetry =      " + this.keyServerRetry);
        }
        HashSet<String> filesAdded = new HashSet<String>();
        List dependencies = this.project.getDependencies();
        ArrayList<File> bundles = new ArrayList<File>();
        ArrayList<File> advices = new ArrayList<File>();
        ArrayList<File> signatures = new ArrayList<File>();
        if (this.includeDependencies) {
            this.resolve(dependencies, bundles, advices, signatures, filesAdded);
        }
        if (this.includeManaged) {
            this.resolve(this.project.getDependencyManagement().getDependencies(), bundles, advices, signatures, filesAdded);
        }
        if (this.includeReactor) {
            List allProjects = this.session.getAllProjects();
            for (MavenProject mavenProject : allProjects) {
                if (this.skipProject(mavenProject)) continue;
                Artifact artifact = mavenProject.getArtifact();
                File file = artifact.getFile();
                Object attachedSignatureFile = null;
                if (this.includePGPSignature) {
                    attachedSignatureFile = this.pgpService.getAttachedSignature(mavenProject);
                }
                bundles.add(file);
                advices.add(this.createMavenAdvice(artifact));
                signatures.add((File)attachedSignatureFile);
            }
        }
        if (this.categoryFile.exists()) {
            categoryURI = this.categoryFile.toURI().toASCIIString();
        } else {
            try {
                File categoryGenFile = File.createTempFile("category", ".xml");
                try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(categoryGenFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]));){
                    writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    writer.println("<site>");
                    writer.println("<category-def name=\"bundles\" label=\"" + this.categoryName + "\"/>");
                    writer.println("<iu>");
                    writer.println("<category name=\"bundles\"/>");
                    writer.println(" <query><expression type=\"match\">providedCapabilities.exists(p | p.namespace == 'osgi.bundle')</expression></query>");
                    writer.println("</iu>");
                    writer.println("</site>");
                }
                categoryGenFile.deleteOnExit();
                categoryURI = categoryGenFile.toURI().toASCIIString();
            }
            catch (IOException e) {
                throw new MojoExecutionException("failed to generate category.xml", (Exception)e);
            }
        }
        File bundlesFile = this.writeFileList(bundles, "bundles");
        File advicesFile = this.writeFileList(advices, "advices");
        File signaturesFile = this.writeFileList(signatures, "signatures");
        HashMap<Long, PGPPublicKeyRing> publicKeys = new HashMap<Long, PGPPublicKeyRing>();
        if (this.includePGPSignature) {
            for (File file : signatures) {
                if (file == null) continue;
                try (InputStream in = PGPUtil.getDecoderStream((InputStream)new FileInputStream(file));){
                    BcPGPObjectFactory pgpFact = new BcPGPObjectFactory(in);
                    Object o = pgpFact.nextObject();
                    if (!(o instanceof PGPSignatureList)) continue;
                    PGPSignatureList list = (PGPSignatureList)o;
                    for (int i = 0; i < list.size(); ++i) {
                        PGPSignature signature = list.get(i);
                        long keyID = signature.getKeyID();
                        if (publicKeys.containsKey(keyID)) continue;
                        ArrayList<Throwable> errors = new ArrayList<Throwable>();
                        for (String keyServer : keyServers) {
                            try {
                                PGPPublicKeyRing pGPPublicKeyRing = this.pgpService.getPublicKey(keyID, keyServer, this.keyServerRetry);
                                if (pGPPublicKeyRing == null) break;
                                publicKeys.put(keyID, pGPPublicKeyRing);
                                break;
                            }
                            catch (IOException | PGPException throwable) {
                                errors.add(throwable);
                            }
                        }
                        if (errors.isEmpty()) continue;
                        MojoFailureException exception = new MojoFailureException("Loading key from any server failed");
                        for (Exception exception2 : errors) {
                            exception.addSuppressed((Throwable)exception2);
                        }
                        throw exception;
                    }
                }
                catch (IOException e) {
                    this.logger.warn("processing signature file " + file.getAbsolutePath() + " failed!", (Throwable)e);
                }
            }
        }
        File publicKeysFile = null;
        Stream.Builder<String> arguments = Stream.builder();
        if (publicKeys.size() > 0) {
            try {
                publicKeysFile = File.createTempFile("publicKeys", ".pgp");
                publicKeysFile.deleteOnExit();
                PGPPublicKeyRingCollection collection = new PGPPublicKeyRingCollection(publicKeys.values());
                try (ArmoredOutputStream out = new ArmoredOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(publicKeysFile)));){
                    collection.encode((OutputStream)out);
                }
                arguments.add("-publicKeys");
                arguments.add(publicKeysFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new MojoExecutionException("failed to generate public-key section", e);
            }
        }
        this.destination.mkdirs();
        arguments.add("-artifactRepository");
        arguments.add(this.destination.toURI().toString());
        arguments.add("-metadataRepository");
        arguments.add(this.destination.toURI().toString());
        arguments.add("-apublish");
        arguments.add("false");
        arguments.add("-bundles");
        arguments.add(bundlesFile.getAbsolutePath());
        arguments.add("-advices");
        arguments.add(advicesFile.getAbsolutePath());
        arguments.add("-signatures");
        arguments.add(signaturesFile.getAbsolutePath());
        arguments.add("-categoryDefinition");
        arguments.add(categoryURI);
        arguments.add("-artifactRepositoryName");
        arguments.add(this.project.getName());
        arguments.add("-metadataRepositoryName");
        arguments.add(this.project.getName());
        arguments.add("-rules");
        arguments.add("(&(classifier=osgi.bundle));mvn:${maven.groupId}:${maven.artifactId}:${maven.version}:${maven.extension}:${maven.classifier}");
        TychoFeaturesAndBundlesPublisherApplication application = new TychoFeaturesAndBundlesPublisherApplication();
        try {
            result = application.run((String[])arguments.build().toArray(String[]::new));
        }
        catch (Exception e) {
            throw new MojoFailureException((Throwable)e);
        }
        for (File file : advices) {
            file.delete();
        }
        bundlesFile.delete();
        advicesFile.delete();
        signaturesFile.delete();
        if (publicKeysFile != null) {
            publicKeysFile.delete();
        }
        if (result != IApplication.EXIT_OK) {
            throw new MojoFailureException("P2 publisher return code was " + String.valueOf(result));
        }
        ZipArchiver archiver = new ZipArchiver();
        MavenArchiver.parseBuildOutputTimestamp((String)this.outputTimestamp).map(FileTime::from).ifPresent(modifiedTime -> archiver.configureReproducibleBuild(modifiedTime));
        File destFile = new File(this.buildDirectory, "p2-site.zip");
        archiver.setDestFile(destFile);
        archiver.addFileSet((FileSet)new DefaultFileSet(this.destination));
        try {
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to create archive", (Exception)e);
        }
        if ("p2-maven-repository".equals(this.project.getPackaging()) && this.execution.getExecutionId().startsWith("default-")) {
            Artifact artifact = this.project.getArtifact();
            artifact.setFile(destFile);
            artifact.setArtifactHandler((ArtifactHandler)new DefaultArtifactHandler("zip"));
        } else {
            this.projectHelper.attachArtifact(this.project, "zip", "p2site", destFile);
        }
    }

    private List<String> getKeyServers() {
        if (this.keyServerUrls != null && !this.keyServerUrls.isEmpty()) {
            return this.keyServerUrls;
        }
        return DEFAULT_KEY_SERVER;
    }

    protected File writeFileList(List<File> files, String name) throws MojoExecutionException {
        try {
            File fileList = File.createTempFile(name, ".txt");
            fileList.deleteOnExit();
            FileUtils.writeLines((File)fileList, (String)StandardCharsets.UTF_8.name(), files.stream().map(f -> f == null ? "" : f.getAbsolutePath()).toList());
            return fileList;
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to generate " + name + " list", (Exception)e);
        }
    }

    protected void resolve(List<Dependency> dependencies, List<File> bundles, List<File> advices, List<File> signatures, Set<String> filesAdded) throws MojoExecutionException {
        for (Dependency dependency : dependencies) {
            this.logger.debug("resolving " + dependency.getGroupId() + "::" + dependency.getArtifactId() + "::" + dependency.getVersion() + "::" + dependency.getClassifier());
            Artifact artifact = this.repositorySystem.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
            Set<Artifact> artifacts = this.resolveArtifact(artifact, this.includeTransitiveDependencies);
            for (Artifact resolvedArtifact : artifacts) {
                this.logger.debug("    resolved " + resolvedArtifact.getGroupId() + "::" + resolvedArtifact.getArtifactId() + "::" + resolvedArtifact.getVersion() + "::" + resolvedArtifact.getClassifier());
                File file = resolvedArtifact.getFile();
                if (!filesAdded.add(file.getAbsolutePath())) continue;
                bundles.add(file);
                advices.add(this.createMavenAdvice(resolvedArtifact));
                signatures.add(this.getSignatureFile(artifact));
            }
        }
    }

    protected File createMavenAdvice(Artifact artifact) throws MojoExecutionException {
        try {
            int cnt = 0;
            File p2 = File.createTempFile("p2properties", ".inf");
            p2.deleteOnExit();
            Properties properties = new Properties();
            this.addProvidesAndProperty(properties, "maven-groupId", artifact.getGroupId(), cnt++);
            this.addProvidesAndProperty(properties, "maven-artifactId", artifact.getArtifactId(), cnt++);
            this.addProvidesAndProperty(properties, "maven-version", artifact.getVersion(), cnt++);
            this.addProvidesAndProperty(properties, "maven-extension", artifact.getType(), cnt++);
            this.addProvidesAndProperty(properties, "maven-classifier", artifact.getClassifier(), cnt++);
            this.addProvidesAndProperty(properties, "maven-scope", artifact.getScope(), cnt++);
            ReproducibleUtils.storeProperties((Properties)properties, (Path)p2.toPath());
            return p2;
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to generate p2.inf", (Exception)e);
        }
    }

    private void addProvidesAndProperty(Properties properties, String key, String value, int i) {
        this.addProvides(properties, key.replace('-', '.'), value, null, i);
        this.addProperty(properties, key, value, i);
    }

    private void addProvides(Properties properties, String namespace, String name, String version, int i) {
        if (name != null && !name.isBlank()) {
            properties.setProperty("provides." + i + ".namespace", namespace);
            properties.setProperty("provides." + i + ".name", name);
            if (version != null && !version.isBlank()) {
                properties.setProperty("provides." + i + ".version", version);
            }
        }
    }

    private void addProperty(Properties properties, String name, String value, int i) {
        if (value != null && !value.isBlank()) {
            properties.setProperty("properties." + i + ".name", name);
            properties.setProperty("properties." + i + ".value", value);
        }
    }

    protected Set<Artifact> resolveArtifact(Artifact artifact, boolean resolveTransitively) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setOffline(this.session.isOffline());
        request.setLocalRepository(this.session.getLocalRepository());
        request.setResolveTransitively(resolveTransitively);
        request.setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        return result.getArtifacts();
    }

    private File getSignatureFile(Artifact artifact) {
        if (this.includePGPSignature) {
            try {
                return this.pgpService.getSignatureFile(artifact, this.session.getRepositorySession(), this.project.getRemoteProjectRepositories());
            }
            catch (ArtifactResolutionException artifactResolutionException) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean skipProject(MavenProject mavenProject) {
        String packaging = mavenProject.getPackaging();
        if (packaging.equalsIgnoreCase("pom")) {
            return true;
        }
        Artifact artifact = mavenProject.getArtifact();
        if (artifact == null) {
            return true;
        }
        File file = artifact.getFile();
        if (file == null || !file.isFile()) {
            return true;
        }
        return this.isSkippedDeploy(mavenProject);
    }

    protected boolean isSkippedDeploy(MavenProject mavenProject) {
        String property = mavenProject.getProperties().getProperty("maven.deploy.skip");
        if (property != null) {
            boolean skip = Boolean.parseBoolean(property);
            this.getLog().debug((CharSequence)("Deploy is" + (skip ? "" : " not") + " skipped in MavenProject " + mavenProject.getName() + " because of property 'maven.deploy.skip'"));
            return skip;
        }
        String pluginId = "org.apache.maven.plugins:maven-deploy-plugin";
        property = MavenP2SiteMojo.getPluginParameter(mavenProject, pluginId, "skip");
        if (property != null) {
            boolean skip = Boolean.parseBoolean(property);
            this.getLog().debug((CharSequence)("Deploy is" + (skip ? "" : " not") + " skipped in MavenProject " + mavenProject.getName() + " because of configuration of the plugin 'org.apache.maven.plugins:maven-deploy-plugin'"));
            return skip;
        }
        if (mavenProject.getParent() != null) {
            return this.isSkippedDeploy(mavenProject.getParent());
        }
        this.getLog().debug((CharSequence)("Not skipping deploy of MavenProject '" + mavenProject.getName() + "'"));
        return false;
    }

    private static String getPluginParameter(MavenProject p, String pluginId, String param) {
        Xpp3Dom xpp3Dom;
        Plugin plugin = MavenP2SiteMojo.getPlugin(p, pluginId);
        if (plugin != null && (xpp3Dom = (Xpp3Dom)plugin.getConfiguration()) != null && xpp3Dom.getChild(param) != null && xpp3Dom.getChild(param).getValue() != null && !xpp3Dom.getChild(param).getValue().isEmpty()) {
            return xpp3Dom.getChild(param).getValue();
        }
        return null;
    }

    private static Plugin getPlugin(MavenProject p, String pluginId) {
        if (p.getBuild() == null || p.getBuild().getPluginsAsMap() == null) {
            return null;
        }
        Plugin plugin = (Plugin)p.getBuild().getPluginsAsMap().get(pluginId);
        if (plugin == null && p.getBuild().getPluginManagement() != null && p.getBuild().getPluginManagement().getPluginsAsMap() != null) {
            plugin = (Plugin)p.getBuild().getPluginManagement().getPluginsAsMap().get(pluginId);
        }
        return plugin;
    }
}

