/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import aQute.bnd.osgi.repository.XMLResourceGenerator;
import aQute.bnd.repository.fileset.FileSetRepository;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.MatchPattern;
import org.eclipse.tycho.FileLockService;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.EclipseRepositoryProject;
import org.eclipse.tycho.model.Category;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.p2.tools.DestinationRepositoryDescriptor;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReference;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.p2resolver.TargetDefinitionVariableResolver;
import org.eclipse.tycho.p2tools.RepositoryReferenceTool;
import org.eclipse.tycho.plugins.p2.repository.AbstractRepositoryMojo;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.osgi.service.repository.Repository;

@Mojo(name="assemble-repository", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class AssembleRepositoryMojo
extends AbstractRepositoryMojo {
    @Parameter(defaultValue="true")
    private boolean createArtifactRepository;
    @Parameter(defaultValue="false")
    private boolean includeAllDependencies;
    @Parameter(defaultValue="false")
    private boolean includeAllSources;
    @Parameter(defaultValue="false")
    private boolean filterProvided;
    @Parameter(defaultValue="false")
    private boolean includeRequiredPlugins;
    @Parameter(defaultValue="false")
    private boolean includeRequiredFeatures;
    @Parameter(defaultValue="true")
    private boolean compress;
    @Parameter(defaultValue="true")
    private boolean xzCompress;
    @Parameter(defaultValue="true")
    private boolean keepNonXzIndexFiles;
    @Parameter(defaultValue="${project.name}")
    private String repositoryName;
    @Parameter(defaultValue="${project.basedir}")
    private File categoriesDirectory;
    @Parameter
    private Map<String, String> profileProperties;
    @Parameter
    private Map<String, String> extraArtifactRepositoryProperties;
    @Parameter
    private boolean addPomRepositoryReferences;
    @Parameter
    private boolean addIUTargetRepositoryReferences;
    @Parameter
    private RepositoryReferenceFilter repositoryReferenceFilter = new RepositoryReferenceFilter();
    @Parameter
    private boolean generateOSGiRepository;
    @Parameter(defaultValue="repository.xml")
    private String repositoryFileName;
    @Component
    private RepositoryReferenceTool repositoryReferenceTool;
    @Component
    MirrorApplicationService mirrorApp;
    @Component
    private TargetDefinitionVariableResolver varResolver;
    @Component(role=TychoProject.class, hint="eclipse-repository")
    private EclipseRepositoryProject eclipseRepositoryProject;
    @Component
    private FileLockService fileLockService;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block21: {
            File destination = this.getAssemblyRepositoryLocation();
            try (Closeable locking = this.fileLockService.lockVirtually(destination);){
                File features;
                destination.mkdirs();
                this.copyResources(destination);
                ReactorProject reactorProject = this.getReactorProject();
                List projectSeeds = reactorProject.getDependencySeeds();
                if (projectSeeds.isEmpty()) {
                    this.getLog().warn((CharSequence)"No content specified for p2 repository");
                    return;
                }
                reactorProject.setContextValue(TychoConstants.CTX_METADATA_ARTIFACT_LOCATION, (Object)this.categoriesDirectory);
                MavenProject project = this.getProject();
                RepositoryReferences sources = this.repositoryReferenceTool.getVisibleRepositories(project, this.getSession(), 1);
                sources.setTargetPlatform((TargetPlatform)this.projectManager.getTargetPlatform(project).orElseThrow(() -> new MojoFailureException("Tycho build extension not configured for " + project)));
                List<RepositoryReference> repositoryReferences = this.getCategories(this.categoriesDirectory).stream().map(Category::getRepositoryReferences).flatMap(Collection::stream).map(ref -> new RepositoryReference(ref.getName(), ref.getLocation(), ref.isEnabled())).toList();
                Predicate<String> autoReferencesFilter = this.buildRepositoryReferenceLocationFilter();
                ArrayList autoRepositoryRefeferences = new ArrayList();
                if (this.addPomRepositoryReferences) {
                    project.getRepositories().stream().filter(pomRepo -> "p2".equals(pomRepo.getLayout())).filter(pomRepo -> autoReferencesFilter.test(pomRepo.getUrl())).map(pomRepo -> new RepositoryReference(pomRepo.getName(), pomRepo.getUrl(), true)).forEach(autoRepositoryRefeferences::add);
                }
                if (this.addIUTargetRepositoryReferences) {
                    this.projectManager.getTargetPlatformConfiguration(project).getTargets().stream().flatMap(tpFile -> tpFile.getLocations().stream()).filter(TargetDefinition.InstallableUnitLocation.class::isInstance).map(TargetDefinition.InstallableUnitLocation.class::cast).flatMap(iu -> iu.getRepositories().stream()).map(iuRepo -> this.varResolver.resolve(iuRepo.getLocation())).filter(autoReferencesFilter).map(location -> new RepositoryReference(null, location, true)).forEach(autoRepositoryRefeferences::add);
                }
                DestinationRepositoryDescriptor destinationRepoDescriptor = new DestinationRepositoryDescriptor(destination, this.repositoryName, this.compress, this.xzCompress, this.keepNonXzIndexFiles, !this.createArtifactRepository, true, this.extraArtifactRepositoryProperties, repositoryReferences, autoRepositoryRefeferences);
                this.mirrorApp.mirrorReactor(sources, destinationRepoDescriptor, (Collection)projectSeeds, this.getBuildContext(), this.includeAllDependencies, this.includeAllSources, this.includeRequiredPlugins, this.includeRequiredFeatures, this.filterProvided, this.repositoryReferenceFilter.addOnlyProviding, this.profileProperties);
                if (!this.generateOSGiRepository) break block21;
                XMLResourceGenerator resourceGenerator = new XMLResourceGenerator();
                resourceGenerator.name(this.repositoryName);
                resourceGenerator.base(destination.toURI());
                File plugins = new File(destination, "plugins");
                if (plugins.isDirectory()) {
                    File[] files = plugins.listFiles(path -> path.getName().endsWith(".jar") && path.isFile());
                    try {
                        resourceGenerator.repository((Repository)new FileSetRepository("plugins", Arrays.asList(files)));
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("Could not read p2 repository plugins", e);
                    }
                }
                if ((features = new File(destination, "features")).isDirectory()) {
                    File[] files;
                    for (File featureFile : files = features.listFiles(path -> path.getName().endsWith(".jar") && path.isFile())) {
                        try {
                            Feature feature = Feature.readJar((File)featureFile);
                            feature.toResource().forEach(arg_0 -> ((XMLResourceGenerator)resourceGenerator).resource(arg_0));
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException("Could not read feature " + featureFile, (Exception)e);
                        }
                    }
                }
                try {
                    Object filename = this.compress ? this.repositoryFileName + ".gz" : this.repositoryFileName;
                    resourceGenerator.save(new File(destination, (String)filename));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not write OSGi Repository!", (Exception)e);
                }
            }
            catch (IOException | FacadeException e) {
                throw new MojoExecutionException("Could not assemble p2 repository", (Exception)e);
            }
        }
    }

    private void copyResources(File destination) throws MojoExecutionException {
        File outputDir = new File(this.getProject().getBuild().getOutputDirectory());
        try {
            if (outputDir.isDirectory()) {
                this.getLog().info((CharSequence)String.format("Copying resources from %s to %s", outputDir, destination));
                FileUtils.copyDirectoryStructure((File)outputDir, (File)destination);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying resources", (Exception)e);
        }
    }

    private List<Category> getCategories(File categoriesDirectory) {
        return this.eclipseRepositoryProject.loadCategories(categoriesDirectory);
    }

    private Predicate<String> buildRepositoryReferenceLocationFilter() {
        List<Predicate> filters = this.repositoryReferenceFilter.exclude.stream().map(exclusionPattern -> {
            boolean isNegated = false;
            if (exclusionPattern.startsWith("![") && exclusionPattern.endsWith("]")) {
                exclusionPattern = exclusionPattern.substring(2, exclusionPattern.length() - 1);
                isNegated = true;
            }
            MatchPattern pattern = MatchPattern.fromString((String)exclusionPattern);
            return isNegated ? ref -> !pattern.matchPath(ref, true) : ref -> pattern.matchPath(ref, true);
        }).toList();
        return ref -> filters.stream().noneMatch(f -> f.test(ref));
    }

    public static class RepositoryReferenceFilter {
        public boolean addOnlyProviding = true;
        public List<String> exclude = List.of();
    }
}

