/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

public class PackageUpdateSiteMojo
extends AbstractMojo {
    protected MavenProject project;
    private File target;
    private boolean archiveSite;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.target == null || !this.target.isDirectory()) {
            throw new MojoExecutionException("Update site folder does not exist at: " + this.target != null ? this.target.getAbsolutePath() : "null");
        }
        try {
            ZipArchiver siteZipper = new ZipArchiver();
            File siteDestination = new File(this.target.getParentFile(), "site.zip");
            siteZipper.addFile(new File(this.target, "site.xml"), "site.xml");
            siteZipper.setDestFile(siteDestination);
            siteZipper.createArchive();
            this.project.getArtifact().setFile(siteDestination);
            if (this.archiveSite) {
                ZipArchiver asssemblyZipper = new ZipArchiver();
                File asssemblyDestFile = new File(this.target.getParentFile(), "site_assembly.zip");
                asssemblyZipper.addDirectory(this.target);
                asssemblyZipper.setDestFile(asssemblyDestFile);
                asssemblyZipper.createArchive();
                this.projectHelper.attachArtifact(this.project, "zip", "assembly", asssemblyDestFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error packing update site", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error packing update site", (Exception)((Object)e));
        }
    }
}

