/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.tycho.core.PluginDescription;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.model.PluginRef;
import org.eclipse.tycho.packaging.UpdateSiteAssembler;

public class ProductAssembler
extends UpdateSiteAssembler {
    private final TargetEnvironment environment;
    private boolean includeSources;
    private final BundleReader manifestReader;

    public ProductAssembler(PlexusContainer plexus, BundleReader manifestReader, File target, TargetEnvironment environment) {
        super(plexus, target);
        this.manifestReader = manifestReader;
        this.setUnpackPlugins(true);
        this.setUnpackFeatures(true);
        this.environment = environment;
    }

    @Override
    public void visitPlugin(PluginDescription plugin) {
        if (!this.matchEntivonment(plugin)) {
            return;
        }
        if (!this.includeSources && this.isSourceBundle(plugin)) {
            return;
        }
        super.visitPlugin(plugin);
    }

    private boolean isSourceBundle(PluginDescription plugin) {
        OsgiManifest mf = this.manifestReader.loadManifest(plugin.getLocation());
        return mf.getValue("Eclipse-SourceBundle") != null;
    }

    @Override
    protected boolean isDirectoryShape(PluginDescription plugin, File location) {
        if (super.isDirectoryShape(plugin, location)) {
            return true;
        }
        OsgiManifest mf = this.manifestReader.loadManifest(location);
        return mf.isDirectoryShape();
    }

    protected boolean matchEntivonment(PluginDescription plugin) {
        PluginRef ref = plugin.getPluginRef();
        return ref == null || this.environment == null || this.environment.match(ref.getOs(), ref.getWs(), ref.getArch());
    }

    public void setIncludeSources(boolean includeSources) {
        this.includeSources = includeSources;
    }
}

