/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.tycho.core.resolver.DefaultTargetPlatformConfigurationReader;

@Mojo(name="package-target-definition", defaultPhase=LifecyclePhase.PACKAGE)
public class PackageTargetDefinitionMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Component
    MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] targetFiles;
        for (File targetFile : targetFiles = DefaultTargetPlatformConfigurationReader.listTargetFiles((File)this.project.getBasedir())) {
            if (DefaultTargetPlatformConfigurationReader.isPrimaryTarget((MavenProject)this.project, (File)targetFile, (File[])targetFiles)) {
                this.project.getArtifact().setFile(targetFile);
                continue;
            }
            this.projectHelper.attachArtifact(this.project, targetFile, FilenameUtils.getBaseName((String)targetFile.getName()));
        }
        if (this.project.getArtifact().getFile() == null) {
            DefaultTargetPlatformConfigurationReader.throwNoPrimaryTargetFound((MavenProject)this.project, (File[])targetFiles);
        }
    }
}

