/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="update-consumer-pom", threadSafe=true, defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class UpdateConsumerPomMojo
extends AbstractMojo {
    private static final String POLYGLOT_POM_TYCHO = ".polyglot.pom.tycho";
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Component(role=ModelWriter.class)
    protected ModelWriter modelWriter;
    @Component(role=ModelReader.class)
    protected ModelReader modelReader;
    @Parameter(defaultValue="${project.basedir}", required=true)
    protected File outputDirectory;
    @Parameter(defaultValue=".tycho-consumer-pom.xml", required=true)
    protected String tychoPomFilename;
    @Parameter(defaultValue="true")
    protected boolean deleteOnExit = true;
    @Parameter
    protected Boolean skipPomGeneration;
    @Parameter(defaultValue="true")
    protected boolean updatePomFile = true;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public void execute() throws MojoExecutionException, MojoFailureException {
        String relativePath;
        Model projectModel;
        if (this.skipPomGeneration == null ? !this.archive.isAddMavenDescriptor() : this.skipPomGeneration != false) {
            return;
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.project.getBasedir();
        }
        this.getLog().debug((CharSequence)"Generate pom descriptor with updated dependencies...");
        try {
            projectModel = this.modelReader.read(this.project.getFile(), null);
        }
        catch (IOException e) {
            throw new MojoExecutionException("reading the model failed!", (Exception)e);
        }
        List dependencies = projectModel.getDependencies();
        dependencies.clear();
        List<Dependency> list = Objects.requireNonNullElse(this.project.getDependencies(), Collections.emptyList());
        for (Dependency dep : list) {
            Dependency copy = dep.clone();
            copy.setSystemPath(null);
            if (dep.getGroupId().startsWith("p2.eclipse.") && "system".equals(dep.getScope())) {
                copy.setOptional(true);
                copy.setScope("provided");
            }
            dependencies.add(copy);
        }
        Parent parent = projectModel.getParent();
        if (parent != null && (relativePath = parent.getRelativePath()) != null && relativePath.endsWith(POLYGLOT_POM_TYCHO)) {
            parent.setRelativePath(relativePath.substring(0, relativePath.length() - POLYGLOT_POM_TYCHO.length()) + "pom.xml");
        }
        File output = new File(this.outputDirectory, this.tychoPomFilename);
        if (this.deleteOnExit) {
            output.deleteOnExit();
        }
        try {
            this.modelWriter.write(output, null, projectModel);
        }
        catch (IOException e) {
            throw new MojoExecutionException("writing the model failed!", (Exception)e);
        }
        if (this.updatePomFile) {
            this.project.setFile(output);
        }
    }
}

