/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging.reverseresolve;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kong.unirest.GetRequest;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.json.JSONObject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.LegacySupport;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.packaging.reverseresolve.ArtifactCoordinateResolver;

@Component(role=ArtifactCoordinateResolver.class, hint="central")
public class MavenCentralArtifactCoordinateResolver
implements ArtifactCoordinateResolver {
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private Logger log;

    @Override
    public Optional<Dependency> resolve(Path path) {
        block11: {
            MavenSession session = this.legacySupport.getSession();
            if (session != null && session.isOffline()) {
                return Optional.empty();
            }
            try {
                JSONObject response;
                if (!Files.isRegularFile(path, new LinkOption[0])) break block11;
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                byte[] buffer = new byte[8192];
                try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                    int read;
                    while ((read = stream.read(buffer)) > -1) {
                        if (read <= 0) continue;
                        digest.update(buffer, 0, read);
                    }
                }
                String sha1Hash = MavenCentralArtifactCoordinateResolver.toHexString(digest.digest());
                GetRequest request = (GetRequest)((GetRequest)Unirest.get((String)"https://search.maven.org/solrsearch/select").queryString("q", (Object)("1:" + sha1Hash))).queryString("wt", (Object)"json");
                JSONObject node = ((JsonNode)request.asJson().getBody()).getObject();
                if (node.has("response") && (response = node.getJSONObject("response")).has("numFound") && response.getInt("numFound") == 1) {
                    JSONObject coordinates = response.getJSONArray("docs").getJSONObject(0);
                    Dependency dependency = new Dependency();
                    dependency.setArtifactId(coordinates.getString("a"));
                    dependency.setGroupId(coordinates.getString("g"));
                    dependency.setVersion(coordinates.getString("v"));
                    dependency.setType(coordinates.getString("p"));
                    return Optional.of(dependency);
                }
            }
            catch (Exception e) {
                this.log.debug("Can't check " + path + " from central because of " + e, (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private static String toHexString(byte[] bytes) {
        return IntStream.range(0, bytes.length).mapToObj(i -> String.format("%02X", bytes[i])).collect(Collectors.joining());
    }
}

