/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.PackagingType;
import org.eclipse.tycho.packaging.reverseresolve.ArtifactCoordinateResolver;

@Mojo(name="update-consumer-pom", threadSafe=true, defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class UpdateConsumerPomMojo
extends AbstractMojo {
    private static final String POLYGLOT_POM_TYCHO = ".polyglot.pom.tycho";
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component(role=ModelWriter.class)
    protected ModelWriter modelWriter;
    @Component(role=ModelReader.class)
    protected ModelReader modelReader;
    @Component
    private Map<String, ArtifactCoordinateResolver> artifactCoordinateResolvers;
    @Component
    ArtifactHandlerManager artifactHandlerManager;
    @Parameter(defaultValue="${project.basedir}", required=true)
    protected File outputDirectory;
    @Parameter(defaultValue=".tycho-consumer-pom.xml", required=true)
    protected String tychoPomFilename;
    @Parameter(defaultValue="true")
    protected boolean deleteOnExit = true;
    @Parameter(defaultValue="true")
    protected boolean replaceTypeWithExtension = true;
    @Parameter
    protected Boolean skipPomGeneration;
    @Parameter(defaultValue="true")
    protected boolean updatePomFile = true;
    @Parameter(defaultValue="false")
    protected boolean includeP2Dependencies = false;
    @Parameter(defaultValue="false")
    protected boolean mapP2Dependencies = false;
    @Parameter(defaultValue="true")
    protected boolean replacePackagingType = true;
    @Parameter(defaultValue="true")
    protected boolean removeModules = true;
    @Parameter(defaultValue="true")
    protected boolean removeBuild = true;
    @Parameter(defaultValue="true")
    protected boolean relativePathFromParent = true;
    @Parameter(defaultValue="true")
    protected boolean removeParent = true;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="local,p2,central")
    private String resolver;
    private Map<String, Optional<Dependency>> resolvedDependencies = new HashMap<String, Optional<Dependency>>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Model projectModel;
        if (this.skipPomGeneration == null ? !this.archive.isAddMavenDescriptor() : this.skipPomGeneration != false) {
            return;
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.project.getBasedir();
        }
        Log log = this.getLog();
        log.debug((CharSequence)"Generating pom descriptor with updated dependencies");
        try {
            projectModel = this.modelReader.read(this.project.getFile(), Map.of());
        }
        catch (IOException e) {
            throw new MojoExecutionException("reading the model failed!", (Exception)e);
        }
        projectModel.setVersion(this.project.getVersion());
        if (this.removeParent) {
            projectModel.setGroupId(this.project.getGroupId());
            projectModel.setParent(null);
        }
        List dependencies = projectModel.getDependencies();
        dependencies.clear();
        List<Dependency> list = Objects.requireNonNullElse(this.project.getDependencies(), Collections.emptyList());
        TreeSet<CallSite> p2Skipped = new TreeSet<CallSite>();
        int resolved = 0;
        for (Dependency dep : list) {
            ArtifactHandler artifactHandler;
            Dependency copy = dep.clone();
            if ("system".equals(dep.getScope())) {
                if (!this.handleSystemScopeDependency(copy)) {
                    p2Skipped.add((CallSite)((Object)(dep.getManagementKey() + " @ " + ArtifactCoordinateResolver.getPath(dep).map(String::valueOf).orElse(dep.getSystemPath()))));
                    continue;
                }
                ++resolved;
            }
            if (this.replaceTypeWithExtension && PackagingType.TYCHO_PACKAGING_TYPES.contains(copy.getType()) && (artifactHandler = this.artifactHandlerManager.getArtifactHandler(copy.getType())) != null) {
                copy.setType(artifactHandler.getExtension());
            }
            dependencies.add(copy);
        }
        Parent parent = projectModel.getParent();
        if (parent != null) {
            MavenProject parentmavenProject = this.project.getParent();
            if (parentmavenProject != null) {
                parent.setVersion(parentmavenProject.getVersion());
            }
            if (this.relativePathFromParent) {
                parent.setRelativePath("../pom.xml");
            } else {
                String relativePath = parent.getRelativePath();
                if (relativePath != null && relativePath.endsWith(POLYGLOT_POM_TYCHO)) {
                    parent.setRelativePath(relativePath.substring(0, relativePath.length() - POLYGLOT_POM_TYCHO.length()) + "pom.xml");
                }
            }
        }
        if (this.replacePackagingType) {
            projectModel.setPackaging(this.mapTychoPackagingTypeToMaven(projectModel.getPackaging()));
        }
        if (this.removeModules) {
            projectModel.setModules(null);
        }
        if (this.removeBuild) {
            projectModel.setBuild(null);
        }
        File output = new File(this.outputDirectory, this.tychoPomFilename);
        if (this.deleteOnExit) {
            output.deleteOnExit();
        }
        if (p2Skipped.isEmpty()) {
            log.info((CharSequence)"All system scoped dependencies were mapped to maven artifacts");
        } else if (this.mapP2Dependencies) {
            log.warn((CharSequence)(resolved + " system scoped dependencies were mapped to maven artifacts, " + p2Skipped.size() + " were skipped"));
            if (log.isDebugEnabled()) {
                for (String string : p2Skipped) {
                    log.debug((CharSequence)("Skipped: " + string));
                }
            }
        } else {
            log.info((CharSequence)(p2Skipped.size() + " system scoped dependencies were not mapped to maven artifacts"));
        }
        try {
            this.modelWriter.write(output, null, projectModel);
        }
        catch (IOException e) {
            throw new MojoExecutionException("writing the model failed!", (Exception)e);
        }
        try {
            if (p2Skipped.size() > 0) {
                File file = new File(this.project.getBuild().getDirectory(), "skippedP2Dependencies.txt");
                file.getParentFile().mkdirs();
                Files.writeString(file.toPath(), (CharSequence)p2Skipped.stream().collect(Collectors.joining("\r\n")), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            log.warn((CharSequence)("Writing additional information failed: " + e));
        }
        if (this.updatePomFile) {
            this.project.setFile(output);
        }
    }

    private String mapTychoPackagingTypeToMaven(String packaging) {
        if ("eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging)) {
            return "jar";
        }
        if ("eclipse-feature".equals(packaging)) {
            return "pom";
        }
        if ("eclipse-target-definition".equals(packaging)) {
            return "target";
        }
        if ("eclipse-repository".equals(packaging)) {
            return "zip";
        }
        return packaging;
    }

    private boolean handleSystemScopeDependency(Dependency dep) {
        if (dep.getGroupId().startsWith("p2.") || this.isEmbeddedJar(dep)) {
            Optional resolved;
            Optional<Path> path;
            if (this.mapP2Dependencies && !this.isEmbeddedJar(dep) && (path = ArtifactCoordinateResolver.getPath(dep)).isPresent() && (resolved = this.resolvedDependencies.computeIfAbsent(path.get().normalize().toString(), nil -> Arrays.stream(this.resolver.split(",")).map(String::strip).map(this.artifactCoordinateResolvers::get).filter(Objects::nonNull).flatMap(resolver -> resolver.resolve(dep, this.project, this.session).stream()).findFirst())).isPresent()) {
                dep.setScope("compile");
                dep.setSystemPath(null);
                Dependency dependency = (Dependency)resolved.get();
                dep.setArtifactId(dependency.getArtifactId());
                dep.setGroupId(dependency.getGroupId());
                dep.setVersion(dependency.getVersion());
                dep.setType(dependency.getType());
                return true;
            }
            dep.setOptional(true);
            dep.setScope("provided");
            dep.setSystemPath(null);
            return this.includeP2Dependencies;
        }
        return true;
    }

    private boolean isEmbeddedJar(Dependency dep) {
        return "eclipse-plugin".equals(dep.getType()) && dep.getClassifier() != null && !dep.getClassifier().isBlank();
    }
}

