/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.buildversion;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.tycho.buildversion.AbstractVersionMojo;
import org.eclipse.tycho.core.ManifestHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="validate-version", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class ValidateVersionMojo
extends AbstractVersionMojo {
    @Parameter(defaultValue="true", property="tycho.strictVersions")
    private boolean strictVersions = true;
    @Component
    ManifestHelper manifestHelper;
    @Component
    BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.buildContext.removeMessages(this.getOSGiMetadataFile());
        String mavenVersion = this.project.getVersion();
        String osgiVersion = this.getOSGiVersion();
        if (osgiVersion == null) {
            return;
        }
        Object qualifiedVersion = this.project.getProperties().get("qualifiedVersion");
        if (mavenVersion.equals(qualifiedVersion)) {
            return;
        }
        if (this.project.getArtifact().isSnapshot() || osgiVersion.endsWith("qualifier")) {
            this.validateSnapshotVersion(mavenVersion, osgiVersion);
        } else {
            this.validateReleaseVersion(mavenVersion, osgiVersion);
        }
    }

    public void validateReleaseVersion(String mavenVersion, String osgiVersion) throws MojoExecutionException {
        if (!mavenVersion.equals(osgiVersion)) {
            this.fail("OSGi version " + osgiVersion + " in " + this.getOSGiMetadataFileName() + " does not match Maven version " + mavenVersion + " in pom.xml");
        }
    }

    public void validateSnapshotVersion(String mavenVersion, String osgiVersion) throws MojoExecutionException {
        if (!mavenVersion.endsWith("SNAPSHOT")) {
            this.fail("Maven version " + mavenVersion + " must have -SNAPSHOT qualifier for SNAPSHOT builds");
        }
        if (!osgiVersion.endsWith("qualifier")) {
            this.fail("OSGi version " + osgiVersion + " must have .qualifier qualifier for SNAPSHOT builds");
        } else {
            String unqualifiedOSGiVersion;
            String unqualifiedMavenVersion = mavenVersion;
            if (mavenVersion.endsWith("SNAPSHOT")) {
                unqualifiedMavenVersion = mavenVersion.substring(0, mavenVersion.length() - "SNAPSHOT".length() - 1);
            }
            if (!unqualifiedMavenVersion.equals(unqualifiedOSGiVersion = osgiVersion.substring(0, osgiVersion.length() - "qualifier".length() - 1))) {
                this.fail("Unqualified OSGi version " + osgiVersion + " must match unqualified Maven version " + mavenVersion + " for SNAPSHOT builds");
            }
        }
    }

    private void fail(String message) throws MojoExecutionException {
        int serv;
        int column;
        int lineNumber;
        File metaDataFile = this.getOSGiMetadataFile();
        if ("eclipse-plugin".equals(this.packaging) || "eclipse-test-plugin".equals(this.packaging)) {
            lineNumber = this.manifestHelper.getLineNumber(metaDataFile, "Bundle-Version");
            column = 0;
        } else {
            lineNumber = 0;
            column = 0;
        }
        int n = serv = this.strictVersions ? 2 : 1;
        if (this.buildContext != null) {
            this.buildContext.addMessage(metaDataFile, lineNumber, column, message, serv, null);
        }
        if (this.strictVersions) {
            throw new MojoExecutionException(message);
        }
        this.getLog().warn((CharSequence)message);
    }
}

