/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.buildversion;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.tycho.buildversion.AbstractVersionMojo;
import org.eclipse.tycho.core.ManifestHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="validate-id", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class ValidateIdMojo
extends AbstractVersionMojo {
    @Parameter(defaultValue="false")
    private boolean skip;
    @Component
    ManifestHelper manifestHelper;
    @Component
    BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File file = this.getOSGiMetadataFile();
        this.buildContext.removeMessages(file);
        if (!this.skip && !this.project.getArtifactId().equals(this.getOSGiId())) {
            int column;
            int lineNumber;
            String message;
            if ("eclipse-feature".equals(this.project.getPackaging())) {
                message = this.mismatchMessageFor("feature ID");
                lineNumber = 0;
                column = 0;
            } else if ("p2-installable-unit".equals(this.project.getPackaging())) {
                message = this.mismatchMessageFor("iu ID");
                lineNumber = 0;
                column = 0;
            } else {
                message = this.mismatchMessageFor("bundle symbolic name");
                lineNumber = this.manifestHelper.getLineNumber(file, "Bundle-SymbolicName");
                column = 0;
            }
            this.buildContext.addMessage(file, lineNumber, column, message, 2, null);
            throw new MojoExecutionException(message);
        }
    }

    private String mismatchMessageFor(String eclipseIdKey) {
        return String.format("The Maven artifactId (currently: \"%1s\") must be the same as the " + eclipseIdKey + " (currently: \"%2s\")", this.project.getArtifactId(), this.getOSGiId());
    }
}

