/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.buildversion;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.build.BuildTimestampProvider;
import org.eclipse.tycho.buildversion.AbstractVersionMojo;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.osgi.framework.Version;

@Mojo(name="build-qualifier", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class BuildQualifierMojo
extends AbstractVersionMojo {
    @Parameter(property="session", readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="yyyyMMddHHmm", property="tycho.buildqualifier.format")
    protected SimpleDateFormat format;
    @Parameter(property="forceContextQualifier")
    protected String forceContextQualifier;
    @Parameter(property="tycho.buildqualifier.provider")
    protected String timestampProvider;
    @Parameter(property="mojoExecution", readonly=true)
    protected MojoExecution execution;
    @Component(role=BuildTimestampProvider.class)
    protected Map<String, BuildTimestampProvider> timestampProviders;
    @Component
    private BuildPropertiesParser buildPropertiesParser;
    @Parameter(alias="jgit.dirtyWorkingTree")
    private String dummy1;
    @Parameter(alias="jgit.ignore")
    private String dummy2;

    public void setFormat(String formatString) {
        this.format = new SimpleDateFormat(formatString);
        this.format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        TychoProjectVersion projectVersion = this.calculateQualifiedVersion();
        this.project.getProperties().put("buildQualifier", projectVersion.qualifier);
        this.project.getProperties().put("unqualifiedVersion", projectVersion.unqualifiedVersion);
        this.project.getProperties().put("qualifiedVersion", projectVersion.getOSGiVersion());
        this.getLog().info((CharSequence)("The project's OSGi version is " + projectVersion.getOSGiVersion()));
    }

    private TychoProjectVersion calculateQualifiedVersion() throws MojoFailureException, MojoExecutionException {
        Version osgiVersion = this.getParsedOSGiVersion();
        if (osgiVersion != null && !"qualifier".equals(osgiVersion.getQualifier())) {
            String unqualifiedVersion = osgiVersion.getMajor() + "." + osgiVersion.getMinor() + "." + osgiVersion.getMicro();
            return new TychoProjectVersion(unqualifiedVersion, osgiVersion.getQualifier());
        }
        String qualifier = this.getDesiredQualifier();
        this.validateQualifier(qualifier);
        String pomOSGiVersion = this.getUnqualifiedVersion();
        String suffix = "." + qualifier;
        if (pomOSGiVersion.endsWith(suffix)) {
            return new TychoProjectVersion(pomOSGiVersion.substring(0, pomOSGiVersion.length() - suffix.length()), qualifier);
        }
        return new TychoProjectVersion(pomOSGiVersion, qualifier);
    }

    protected String getDesiredQualifier() throws MojoExecutionException {
        String qualifier = this.forceContextQualifier;
        if (qualifier == null) {
            qualifier = this.buildPropertiesParser.parse(DefaultReactorProject.adapt((MavenProject)this.project)).getForceContextQualifier();
        }
        if (qualifier == null) {
            Date timestamp = this.getBuildTimestamp();
            qualifier = this.getQualifier(timestamp);
        }
        return qualifier;
    }

    private Version getParsedOSGiVersion() throws MojoFailureException {
        String osgiVersionString = this.getOSGiVersion();
        if (osgiVersionString == null) {
            return null;
        }
        try {
            return Version.parseVersion((String)osgiVersionString);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Not a valid OSGi version " + osgiVersionString + " for project " + this.project);
        }
    }

    void validateQualifier(String qualifier) throws MojoFailureException {
        try {
            Version.parseVersion((String)("1.0.0." + qualifier));
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Invalid build qualifier '" + qualifier + "', it does not match the OSGi qualifier constraint ([0..9]|[a..zA..Z]|'_'|'-')");
        }
    }

    String getQualifier(Date timestamp) {
        return this.format.format(timestamp);
    }

    private String getUnqualifiedVersion() {
        try {
            Version version = Version.parseVersion((String)this.project.getVersion());
            return version.getMajor() + "." + version.getMinor() + "." + version.getMicro();
        }
        catch (RuntimeException version) {
            Object version22;
            try {
                version22 = this.project.getArtifact().getSelectedVersion();
                int majorVersion = version22.getMajorVersion();
                int minorVersion = version22.getMinorVersion();
                int incrementalVersion = version22.getIncrementalVersion();
                if (majorVersion > 0 || minorVersion > 0 || incrementalVersion > 0) {
                    return majorVersion + "." + minorVersion + "." + incrementalVersion;
                }
            }
            catch (OverConstrainedVersionException version22) {
                // empty catch block
            }
            version22 = this.project.getArtifact().getVersion();
            if (((String)version22).endsWith("-SNAPSHOT")) {
                version22 = ((String)version22).substring(0, ((String)version22).length() - "SNAPSHOT".length() - 1);
            }
            return version22;
        }
    }

    protected Date getBuildTimestamp() throws MojoExecutionException {
        String hint = this.timestampProvider != null ? this.timestampProvider : "default";
        BuildTimestampProvider provider = this.timestampProviders.get(hint);
        if (provider == null) {
            throw new MojoExecutionException("Unable to lookup BuildTimestampProvider with hint='" + hint + "'");
        }
        return provider.getTimestamp(this.session, this.project, this.execution);
    }

    static class TychoProjectVersion {
        private String unqualifiedVersion;
        private String qualifier;

        TychoProjectVersion(String unqualifiedVersion, String qualifier) {
            this.unqualifiedVersion = unqualifiedVersion;
            this.qualifier = qualifier == null ? "" : qualifier;
        }

        public String getOSGiVersion() {
            if (this.qualifier.isEmpty()) {
                return this.unqualifiedVersion;
            }
            return this.unqualifiedVersion + "." + this.qualifier;
        }
    }
}

