/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging.reverseresolve;

import java.util.Objects;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.packaging.reverseresolve.ArtifactCoordinateResolver;

@Component(role=ArtifactCoordinateResolver.class, hint="p2")
public class P2ArtifactCoordinateResolver
implements ArtifactCoordinateResolver {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private Logger log;

    @Override
    public Optional<Dependency> resolve(Dependency dependency, MavenProject project, MavenSession session) {
        if (dependency instanceof ArtifactDescriptor) {
            ArtifactDescriptor descriptor = (ArtifactDescriptor)dependency;
            return descriptor.getInstallableUnits().stream().map(iu -> {
                String groupId = iu.getProperty("maven-wrapped-groupId");
                String artifactId = iu.getProperty("maven-wrapped-artifactId");
                String version = iu.getProperty("maven-wrapped-version");
                String classifier = iu.getProperty("maven-wrapped-classifier");
                if (groupId != null && artifactId != null && version != null) {
                    Dependency result = new Dependency();
                    result.setGroupId(groupId);
                    result.setArtifactId(artifactId);
                    result.setVersion(version);
                    result.setType("jar");
                    result.setClassifier(classifier);
                    return result;
                }
                groupId = iu.getProperty("maven-groupId");
                artifactId = iu.getProperty("maven-artifactId");
                version = iu.getProperty("maven-version");
                if (groupId != null && artifactId != null && version != null) {
                    ArtifactTypeRegistry typeRegistry = session.getRepositorySession().getArtifactTypeRegistry();
                    ArtifactType type = typeRegistry.get(Objects.requireNonNullElse(iu.getProperty("maven-type"), "jar"));
                    DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, iu.getProperty("maven-classifier"), type != null ? type.getExtension() : null, version);
                    try {
                        ArtifactRequest request = new ArtifactRequest((Artifact)artifact, project.getRemoteProjectRepositories(), null);
                        Artifact resolved = this.repositorySystem.resolveArtifact(session.getRepositorySession(), request).getArtifact();
                        if (resolved != null) {
                            Dependency result = new Dependency();
                            result.setGroupId(resolved.getGroupId());
                            result.setArtifactId(resolved.getArtifactId());
                            result.setVersion(resolved.getVersion());
                            result.setType(resolved.getExtension());
                            result.setClassifier(resolved.getClassifier());
                            return result;
                        }
                    }
                    catch (Exception e) {
                        this.log.debug("Cannot resolve from repository system because of " + e, (Throwable)e);
                    }
                }
                return null;
            }).filter(Objects::nonNull).findFirst();
        }
        return Optional.empty();
    }
}

