/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.resource.CapReqBuilder;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.SessionScoped;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.classpath.ClasspathContributor;
import org.eclipse.tycho.helper.PluginConfigurationHelper;
import org.eclipse.tycho.helper.PluginRealmHelper;
import org.eclipse.tycho.packaging.ManifestProcessor;

@SessionScoped
@Component(role=ManifestProcessor.class, hint="bnd", instantiationStrategy="")
public class BndManifestProcessor
implements ManifestProcessor {
    @Requirement
    private PluginRealmHelper pluginRealmHelper;
    @Requirement
    private Logger logger;
    @Requirement
    private PluginConfigurationHelper configurationHelper;
    private MavenSession mavenSession;

    @Inject
    public BndManifestProcessor(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public void processManifest(MavenProject mavenProject, Manifest manifest) {
        if (this.configurationHelper.getConfiguration().getBoolean("deriveHeaderFromSource").orElse(Boolean.FALSE).booleanValue()) {
            File output = new File(mavenProject.getBuild().getOutputDirectory());
            if (!output.exists()) {
                return;
            }
            try (Jar jar = new Jar(mavenProject.getId(), output);
                 Analyzer analyzer = new Analyzer(jar);){
                for (Artifact artifact : mavenProject.getArtifacts()) {
                    File file = artifact.getFile();
                    if (file == null || !file.exists() || file.length() == 0L) continue;
                    analyzer.addClasspath(file);
                }
                this.pluginRealmHelper.visitPluginExtensions(mavenProject, this.mavenSession, ClasspathContributor.class, cpc -> {
                    List list = cpc.getAdditionalClasspathEntries(mavenProject, "compile");
                    if (list != null && !list.isEmpty()) {
                        for (ClasspathEntry entry : list) {
                            for (File file : entry.getLocations()) {
                                try {
                                    analyzer.addClasspath(file);
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                });
                Manifest calcManifest = analyzer.calcManifest();
                Attributes mainAttributes = manifest.getMainAttributes();
                Attributes calcAttributes = calcManifest.getMainAttributes();
                this.enhanceReqCap(mainAttributes, calcAttributes);
            }
            catch (Exception e) {
                String message = "Cannot derive header from source";
                if (this.logger.isDebugEnabled()) {
                    this.logger.error(message, (Throwable)e);
                }
                this.logger.warn(message + " (" + e + ")");
            }
        }
    }

    private void enhanceReqCap(Attributes mainAttributes, Attributes calcAttributes) {
        String existingValue = mainAttributes.getValue("Require-Capability");
        String newValue = calcAttributes.getValue("Require-Capability");
        if (newValue != null) {
            Parameters additional = OSGiHeader.parseHeader((String)newValue);
            if (additional.containsKey("osgi.ee")) {
                mainAttributes.remove(new Attributes.Name("Bundle-RequiredExecutionEnvironment"));
            }
            if (existingValue == null) {
                mainAttributes.putValue("Require-Capability", newValue);
            } else {
                this.logger.debug("Existing: " + existingValue);
                this.logger.debug("New:      " + newValue);
                Parameters current = OSGiHeader.parseHeader((String)existingValue);
                if (current.containsKey("osgi.ee")) {
                    additional.remove("osgi.ee");
                }
                List initalCapabilities = CapReqBuilder.getCapabilitiesFrom((Parameters)current);
                List newCapabilities = CapReqBuilder.getCapabilitiesFrom((Parameters)additional);
                if (newCapabilities.isEmpty()) {
                    return;
                }
                LinkedHashSet mergedCapabilities = new LinkedHashSet();
                mergedCapabilities.addAll(initalCapabilities);
                mergedCapabilities.addAll(newCapabilities);
                String merged = mergedCapabilities.stream().map(cap -> String.valueOf(cap).replace("'", "\"")).collect(Collectors.joining(","));
                this.logger.debug("Merged:   " + merged);
                mainAttributes.putValue("Require-Capability", merged);
            }
        }
    }
}

