/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging.reverseresolve;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.tycho.packaging.reverseresolve.ArtifactCoordinateResolver;

@Singleton
@Named(value="local")
public class RepositoryArtifactCoordinateResolver
implements ArtifactCoordinateResolver {
    @Inject
    private RepositorySystem repositorySystem;
    @Inject
    private Logger log;

    @Override
    public Optional<Dependency> resolve(Dependency dep, MavenProject project, MavenSession session) {
        return ArtifactCoordinateResolver.getPath(dep).flatMap(path -> {
            try {
                Properties properties = RepositoryArtifactCoordinateResolver.getArtifactProperties(path);
                if (properties == null) {
                    return Optional.empty();
                }
                String artifactId = properties.getProperty("artifactId");
                String groupId = properties.getProperty("groupId");
                String version = properties.getProperty("version");
                if (artifactId != null && groupId != null && version != null) {
                    String type = FilenameUtils.getExtension((String)path.getFileName().toString());
                    DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, type, version);
                    ArtifactRequest artifactRequest = new ArtifactRequest();
                    artifactRequest.setArtifact((Artifact)artifact);
                    artifactRequest.setRepositories(RepositoryUtils.toRepos((List)project.getRemoteArtifactRepositories()));
                    ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(session.getRepositorySession(), artifactRequest);
                    if (!artifactResult.isResolved()) {
                        this.log.debug("Resolving " + String.valueOf(artifact) + " failed because of: " + String.valueOf(artifactResult.getExceptions()));
                        return Optional.empty();
                    }
                    return Optional.ofNullable(artifactResult.getArtifact()).filter(a -> a.getFile() != null).filter(a -> {
                        try {
                            return FileUtils.contentEquals((File)a.getFile(), (File)path.toFile());
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }).map(a -> {
                        Dependency result = new Dependency();
                        result.setGroupId(a.getGroupId());
                        result.setArtifactId(a.getArtifactId());
                        result.setVersion(a.getVersion());
                        result.setType(a.getExtension());
                        return result;
                    });
                }
            }
            catch (Exception e) {
                this.log.debug("Cannot process " + String.valueOf(path) + " because of " + String.valueOf(e), (Throwable)e);
            }
            return Optional.empty();
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties getArtifactProperties(Path path) throws IOException {
        if (!Files.isRegularFile(path, new LinkOption[0]) || Files.size(path) <= 0L) return null;
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                Properties properties;
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith("META-INF/maven/") || !name.endsWith("pom.properties")) continue;
                InputStream stream = jarFile.getInputStream(jarEntry);
                try {
                    Properties properties2 = new Properties();
                    properties2.load(stream);
                    properties2.setProperty("file-type", FilenameUtils.getExtension((String)path.getFileName().toString()));
                    properties = properties2;
                    if (stream == null) return properties;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream == null) throw throwable;
                        try {
                            stream.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        return null;
                    }
                }
                stream.close();
                return properties;
            }
        }
    }
}

