/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.sbom;

import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.cyclonedx.maven.DefaultModelConverter;
import org.cyclonedx.maven.ModelConverter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.maven.TychoReactorReader;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.resolver.target.ArtifactTypeHelper;
import org.eclipse.tycho.p2maven.repository.P2RepositoryManager;
import org.eclipse.tycho.sbom.TychoSBOMConfiguration;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.eclipse.tycho.targetplatform.TargetDefinitionFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ModelConverter.class)
public class TychoModelConverter
extends DefaultModelConverter {
    private static final String KEY_CONTEXT = TychoSBOMConfiguration.class.toString();
    private static final Logger LOG = LoggerFactory.getLogger(TychoModelConverter.class);
    @Inject
    private P2RepositoryManager repositoryManager;
    @Inject
    private TychoProjectManager projectManager;
    @Inject
    private TychoReactorReader reactorReader;
    @Inject
    private LegacySupport legacySupport;

    public String generatePackageUrl(org.apache.maven.artifact.Artifact mavenArtifact) {
        Artifact artifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)mavenArtifact);
        return this.generatePackageUrl(artifact, true, true, () -> super.generatePackageUrl(mavenArtifact));
    }

    public String generatePackageUrl(Artifact artifact) {
        return this.generatePackageUrl(RepositoryUtils.toArtifact((Artifact)artifact));
    }

    public String generateVersionlessPackageUrl(org.apache.maven.artifact.Artifact mavenArtifact) {
        Artifact artifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)mavenArtifact);
        return this.generatePackageUrl(artifact, false, true, () -> super.generateVersionlessPackageUrl(mavenArtifact));
    }

    public String generateVersionlessPackageUrl(Artifact artifact) {
        return this.generateVersionlessPackageUrl(artifact);
    }

    public String generateClassifierlessPackageUrl(Artifact artifact) {
        return this.generatePackageUrl(artifact, true, false, () -> super.generateClassifierlessPackageUrl(artifact));
    }

    private String generatePackageUrl(Artifact artifact, boolean withVersion, boolean withClassifier, Supplier<String> fallback) {
        TychoSBOMConfiguration sbomConfig = this.getOrCreateCurrentProjectConfiguration();
        if (sbomConfig.getIncludedPackagingTypes().contains(this.reactorReader.getPackagingType(artifact))) {
            String p2purl;
            ArtifactKey artifactKey = this.getQualifiedArtifactKey(artifact);
            IArtifactKey p2artifactKey = ArtifactTypeHelper.toP2ArtifactKey((ArtifactKey)artifactKey);
            boolean isReactorProject = this.reactorReader.getTychoReactorProject(artifact).isPresent();
            if (p2artifactKey != null && (p2purl = this.generateP2PackageUrl(p2artifactKey, withVersion, withClassifier, isReactorProject)) != null) {
                return p2purl;
            }
        }
        return fallback.get();
    }

    String generateP2PackageUrl(IArtifactKey p2artifactKey, boolean withVersion, boolean withClassifier, boolean isReactorProject) {
        String location = this.getRepositoryLocation(p2artifactKey, isReactorProject);
        if (location == null) {
            LOG.warn("Unknown p2 repository for artifact: " + p2artifactKey.getId());
            return null;
        }
        String encodedLocation = URLEncoder.encode(location, StandardCharsets.UTF_8);
        StringBuilder builder = new StringBuilder();
        builder.append("pkg:p2/");
        builder.append(p2artifactKey.getId());
        if (withVersion) {
            builder.append('@');
            builder.append(p2artifactKey.getVersion());
        }
        builder.append('?');
        if (withClassifier) {
            builder.append("classifier=");
            builder.append(p2artifactKey.getClassifier());
            builder.append('&');
        }
        builder.append("location=");
        builder.append(encodedLocation);
        return builder.toString();
    }

    private final String getRepositoryLocation(IArtifactKey p2artifactKey, boolean isReactorProject) {
        MavenSession currentSession = this.legacySupport.getSession();
        if (currentSession == null) {
            LOG.error("Maven session couldn't be found.");
            return null;
        }
        MavenProject currentProject = currentSession.getCurrentProject();
        if (isReactorProject) {
            String defaultUrl = currentProject.getProperties().getProperty("tycho.sbom.url");
            if (defaultUrl == null) {
                LOG.error("'tycho.sbom.url' property not set.");
            }
            return defaultUrl;
        }
        for (TargetDefinition.Repository repository : this.getTargetRepositories(currentProject)) {
            String id = repository.getId();
            URI location = URI.create(repository.getLocation());
            MavenRepositoryLocation mavenRepository = new MavenRepositoryLocation(id, location);
            try {
                IArtifactRepository artifactRepository = this.repositoryManager.getArtifactRepository(mavenRepository);
                if (!artifactRepository.contains(p2artifactKey)) continue;
                return repository.getLocation();
            }
            catch (ProvisionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private ArtifactKey getQualifiedArtifactKey(Artifact artifact) {
        String expandedVersion = artifact.getVersion();
        MavenProject mavenProject = this.reactorReader.getTychoReactorProject(artifact).orElse(null);
        if (mavenProject != null) {
            ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)mavenProject);
            if (reactorProject != null) {
                expandedVersion = reactorProject.getExpandedVersion();
            } else {
                LOG.error(mavenProject + " is not a Tycho project.");
            }
        }
        String type = this.reactorReader.getPackagingType(artifact);
        return new DefaultArtifactKey(type, artifact.getArtifactId(), expandedVersion);
    }

    private List<TargetDefinition.Repository> getTargetRepositories(MavenProject currentProject) {
        TargetPlatformConfiguration targetConfiguration = this.projectManager.getTargetPlatformConfiguration(currentProject);
        ArrayList p2repositories = new ArrayList();
        for (TargetDefinitionFile targetFile : targetConfiguration.getTargets()) {
            for (TargetDefinition.Location location : targetFile.getLocations()) {
                if (!(location instanceof TargetDefinition.InstallableUnitLocation)) continue;
                TargetDefinition.InstallableUnitLocation iuLocation = (TargetDefinition.InstallableUnitLocation)location;
                p2repositories.addAll(iuLocation.getRepositories());
            }
        }
        return Collections.unmodifiableList(p2repositories);
    }

    private synchronized TychoSBOMConfiguration getOrCreateCurrentProjectConfiguration() {
        MavenProject currentProject = this.legacySupport.getSession().getCurrentProject();
        if (currentProject == null) {
            return new TychoSBOMConfiguration();
        }
        TychoSBOMConfiguration projectConfig = (TychoSBOMConfiguration)currentProject.getContextValue(KEY_CONTEXT);
        if (projectConfig == null) {
            projectConfig = new TychoSBOMConfiguration(currentProject);
            currentProject.setContextValue(KEY_CONTEXT, (Object)projectConfig);
        }
        return projectConfig;
    }
}

