/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.sbom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.maven.DefaultProjectDependenciesConverter;
import org.cyclonedx.maven.ProjectDependenciesConverter;
import org.cyclonedx.model.BomReference;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.Metadata;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.IDependencyMetadata;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.p2.tools.P2DependencyTreeGenerator;
import org.eclipse.tycho.sbom.TychoModelConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.codehaus.plexus.component.annotations.Component(role=ProjectDependenciesConverter.class)
public class TychoProjectDependenciesConverter
extends DefaultProjectDependenciesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(TychoProjectDependenciesConverter.class);
    @Inject
    private LegacySupport legacySupport;
    @Inject
    private TychoModelConverter modelConverter;
    @Inject
    private P2DependencyTreeGenerator dependencyGenerator;
    private final Map<IInstallableUnit, List<String>> bomRepresentations = new ConcurrentHashMap<IInstallableUnit, List<String>>();

    public void cleanupBomDependencies(Metadata metadata, Map<String, Component> components, Map<String, Dependency> dependencies) {
        MavenSession mavenSession = this.legacySupport.getSession();
        MavenProject currentProject = mavenSession.getCurrentProject();
        try {
            HashSet unmapped = new HashSet();
            List rootNodes = this.dependencyGenerator.buildDependencyTree(currentProject, unmapped);
            if (rootNodes.isEmpty() && unmapped.isEmpty()) {
                LOG.info("Project " + String.valueOf(currentProject) + " doesn't seem to be a Tycho project. Skip...");
                return;
            }
            TreeSet<Dependency> newDependencies = new TreeSet<Dependency>(Comparator.comparing(BomReference::getRef));
            for (P2DependencyTreeGenerator.DependencyTreeNode rootNode : rootNodes) {
                this.convertToDependency(rootNode, newDependencies);
            }
            for (IInstallableUnit iu : unmapped) {
                for (String bomRef : this.getBomRepresentation(iu)) {
                    newDependencies.add(new Dependency(bomRef));
                }
            }
            for (Dependency dependency : newDependencies) {
                dependencies.put(dependency.getRef(), dependency);
            }
        }
        catch (CoreException e) {
            LOG.error(e.getMessage());
        }
    }

    private void convertToDependency(P2DependencyTreeGenerator.DependencyTreeNode node, Set<Dependency> dependencies) {
        for (String bomRef : this.getBomRepresentation(node.getInstallableUnit())) {
            Dependency dependency = new Dependency(bomRef);
            for (P2DependencyTreeGenerator.DependencyTreeNode childNode : node.getChildren()) {
                for (String childBomRef : this.getBomRepresentation(childNode.getInstallableUnit())) {
                    dependency.addDependency(new Dependency(childBomRef));
                }
                this.convertToDependency(childNode, dependencies);
            }
            dependencies.add(dependency);
        }
    }

    private List<String> getBomRepresentation(IInstallableUnit iu) {
        return this.bomRepresentations.computeIfAbsent(iu, ignore -> {
            MavenSession mavenSession = this.legacySupport.getSession();
            List reactorProjects = mavenSession.getAllProjects();
            for (MavenProject project : reactorProjects) {
                ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)project);
                Set initalUnits = reactorProject.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.INITIAL);
                Set seedUnits = reactorProject.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.SEED);
                if (!initalUnits.contains(iu) && !seedUnits.contains(iu)) continue;
                String bomRef = this.modelConverter.generatePackageUrl(project.getArtifact());
                if (bomRef == null) {
                    LOG.error("Unable to calculate BOM for: " + String.valueOf(project));
                    return Collections.emptyList();
                }
                return Collections.singletonList(bomRef);
            }
            ArrayList<String> bomRefs = new ArrayList<String>();
            for (IArtifactKey p2artifactKey : iu.getArtifacts()) {
                String bomRef = this.modelConverter.generateP2PackageUrl(p2artifactKey, true, true, false);
                if (bomRef == null) {
                    LOG.error("Unable to calculate BOM for: " + String.valueOf(p2artifactKey));
                    continue;
                }
                bomRefs.add(bomRef);
            }
            return Collections.unmodifiableList(bomRefs);
        });
    }
}

