/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.sbom;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class TychoSBOMConfiguration {
    private static final Set<String> DEFAULT_TYPES = Set.of("eclipse-feature", "eclipse-plugin");
    private static final String KEY_INCLUDES = "includes";
    private Set<String> includes = DEFAULT_TYPES;

    public TychoSBOMConfiguration() {
    }

    public TychoSBOMConfiguration(MavenProject currentProject) {
        Object object;
        Plugin plugin = currentProject.getPlugin("org.eclipse.tycho:tycho-sbom");
        if (plugin != null && (object = plugin.getConfiguration()) instanceof Xpp3Dom) {
            Xpp3Dom root = (Xpp3Dom)object;
            this.readIncludes(root.getChild(KEY_INCLUDES));
        }
    }

    private void readIncludes(Xpp3Dom parent) {
        if (parent == null) {
            return;
        }
        this.includes = Arrays.stream(parent.getChildren()).map(Xpp3Dom::getValue).collect(Collectors.toUnmodifiableSet());
    }

    public Set<String> getIncludedPackagingTypes() {
        return this.includes;
    }
}

