/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.packaging.IncludeValidationHelper;
import org.eclipse.tycho.source.AbstractSourceJarMojo;
import org.osgi.framework.Version;

@Mojo(name="plugin-source", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class OsgiSourceMojo
extends AbstractSourceJarMojo {
    static final String GOAL = "plugin-source";
    private static final String MANIFEST_HEADER_ECLIPSE_SOURCE_BUNDLE = "Eclipse-SourceBundle";
    private static final String MANIFEST_BUNDLE_LOCALIZATION_BASENAME = "OSGI-INF/l10n/bundle-src";
    private static final String MANIFEST_BUNDLE_LOCALIZATION_FILENAME = "OSGI-INF/l10n/bundle-src.properties";
    private static final String I18N_KEY_PREFIX = "%";
    private static final String I18N_KEY_BUNDLE_VENDOR = "bundleVendor";
    private static final String I18N_KEY_BUNDLE_NAME = "bundleName";
    private static final String VERSION_QUALIFIER = "qualifier";
    @Parameter(defaultValue="true")
    private boolean sourceBundle;
    @Parameter(defaultValue="false")
    private boolean distinctSourceRoots;
    @Parameter(property="sourceBundleSuffix", defaultValue=".source")
    private String sourceBundleSuffix;
    @Parameter(property="buildQualifier")
    private String qualifier;
    @Parameter(defaultValue="true")
    protected boolean useDefaultSourceExcludes;
    @Parameter(defaultValue="false", readonly=true)
    protected boolean requireSourceRoots;
    @Parameter(defaultValue="true")
    protected boolean strictSrcIncludes;
    @Parameter
    private DefaultFileSet[] additionalFileSets;
    @Parameter(defaultValue="sources")
    private String classifier;
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Component
    private IncludeValidationHelper includeValidationHelper;
    @Component
    private BundleReader bundleReader;

    @Override
    protected List<Resource> getSources(MavenProject p) throws MojoExecutionException {
        return this.getSources(this.project, this.requireSourceRoots, DefaultReactorProject.adapt((MavenProject)this.project).getBuildProperties());
    }

    protected List<Resource> getSources(MavenProject p, boolean requireSourceRoots, BuildProperties buildProperties) throws MojoExecutionException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Map.Entry entry : buildProperties.getJarToSourceFolderMap().entrySet()) {
            for (String sourceFolder : (List)entry.getValue()) {
                String jarName;
                Resource resource = new Resource();
                resource.setDirectory(new File(p.getBasedir(), sourceFolder).getAbsolutePath());
                if (this.distinctSourceRoots && !".".equals(jarName = (String)entry.getKey())) {
                    resource.setTargetPath(OsgiSourceMojo.getSourceRootTargetPath(jarName));
                }
                resources.add(resource);
            }
        }
        if (requireSourceRoots && resources.isEmpty()) {
            throw new MojoExecutionException("no source folders found in build.properties");
        }
        return resources;
    }

    @Override
    protected List<Resource> getResources(MavenProject p) throws MojoExecutionException {
        if (this.excludeResources) {
            return Collections.emptyList();
        }
        BuildProperties buildProperties = DefaultReactorProject.adapt((MavenProject)p).getBuildProperties();
        List srcIncludesList = buildProperties.getSourceIncludes();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (!srcIncludesList.isEmpty()) {
            this.includeValidationHelper.checkSourceIncludesExist(p, buildProperties, this.strictSrcIncludes);
            resources.add(OsgiSourceMojo.createResource(this.project.getBasedir().getAbsolutePath(), srcIncludesList, buildProperties.getSourceExcludes()));
        }
        if (this.additionalFileSets != null) {
            for (DefaultFileSet fileSet : this.additionalFileSets) {
                if (fileSet.getIncludes() == null || fileSet.getIncludes().length <= 0) continue;
                resources.add(OsgiSourceMojo.createResource(fileSet.getDirectory().getAbsolutePath(), OsgiSourceMojo.asList(fileSet.getIncludes()), OsgiSourceMojo.asList(fileSet.getExcludes())));
            }
        }
        if (!srcIncludesList.contains(MANIFEST_BUNDLE_LOCALIZATION_FILENAME)) {
            resources.add(this.generateL10nFile());
        }
        return resources;
    }

    private static List<String> asList(String[] patterns) {
        if (patterns == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(patterns);
    }

    private static Resource createResource(String directory, List<String> includes, List<String> excludes) {
        Resource resource = new Resource();
        resource.setDirectory(directory);
        resource.setExcludes(excludes);
        resource.setIncludes(includes);
        return resource;
    }

    private Resource generateL10nFile() throws MojoExecutionException {
        Properties l10nProps;
        OsgiManifest origManifest = this.bundleReader.loadManifest(this.project.getBasedir());
        String bundleName = this.getL10nResolvedValue(origManifest, "Bundle-Name", l10nProps = this.readL10nProps(origManifest));
        if (bundleName == null) {
            this.getLog().warn((CharSequence)("Bundle-Name header not found in " + new File(this.project.getBasedir(), "META-INF/MANIFEST.MF") + ", fallback to Bundle-SymbolicName for source bundle"));
            bundleName = origManifest.getBundleSymbolicName();
        }
        String sourceBundleName = bundleName + " Source";
        String bundleVendor = this.getL10nResolvedValue(origManifest, "Bundle-Vendor", l10nProps);
        if (bundleVendor == null) {
            this.getLog().warn((CharSequence)("Bundle-Vendor header not found in " + new File(this.project.getBasedir(), "META-INF/MANIFEST.MF") + ", fallback to 'unknown' for source bundle"));
            bundleVendor = "unknown";
        }
        File l10nOutputDir = new File(this.project.getBuild().getDirectory(), "sourcebundle-l10n-gen");
        Properties sourceL10nProps = new Properties();
        sourceL10nProps.setProperty(I18N_KEY_BUNDLE_NAME, sourceBundleName);
        sourceL10nProps.setProperty(I18N_KEY_BUNDLE_VENDOR, bundleVendor);
        File l10nPropsFile = new File(l10nOutputDir, MANIFEST_BUNDLE_LOCALIZATION_FILENAME);
        l10nPropsFile.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(l10nPropsFile);){
            sourceL10nProps.store(out, "Source Bundle Localization");
        }
        catch (IOException e) {
            throw new MojoExecutionException("error while generating source bundle localization file", (Exception)e);
        }
        Resource l10nResource = new Resource();
        l10nResource.setDirectory(l10nOutputDir.getAbsolutePath());
        l10nResource.setIncludes(Collections.singletonList(MANIFEST_BUNDLE_LOCALIZATION_FILENAME));
        return l10nResource;
    }

    protected Properties readL10nProps(OsgiManifest manifest) throws MojoExecutionException {
        File l10nPropsFile;
        boolean hasL10nProperty;
        String bundleL10nBase = manifest.getValue("Bundle-Localization");
        boolean bl = hasL10nProperty = bundleL10nBase != null;
        if (bundleL10nBase == null) {
            bundleL10nBase = "OSGI-INF/l10n/bundle";
        }
        if (!(l10nPropsFile = new File(this.project.getBasedir(), bundleL10nBase + ".properties")).isFile()) {
            bundleL10nBase = "plugin";
            l10nPropsFile = new File(this.project.getBasedir(), bundleL10nBase + ".properties");
            if (!l10nPropsFile.isFile()) {
                if (hasL10nProperty) {
                    this.getLog().warn((CharSequence)("bundle localization file " + l10nPropsFile + " not found"));
                }
                return null;
            }
        }
        Properties l10nProps = new Properties();
        try (FileInputStream in = new FileInputStream(l10nPropsFile);){
            l10nProps.load(in);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error loading " + l10nPropsFile, (Exception)e);
        }
        return l10nProps;
    }

    private String getL10nResolvedValue(OsgiManifest manifest, String manifestHeaderKey, Properties l10nProps) throws MojoExecutionException {
        String value = manifest.getValue(manifestHeaderKey);
        if (value == null || !value.startsWith(I18N_KEY_PREFIX)) {
            return value;
        }
        if (l10nProps == null) {
            return null;
        }
        String key = value.substring(1).trim();
        return l10nProps.getProperty(key);
    }

    @Override
    protected String getClassifier() {
        return this.classifier;
    }

    @Override
    protected void updateSourceManifest(MavenArchiveConfiguration mavenArchiveConfiguration) {
        super.updateSourceManifest(mavenArchiveConfiguration);
        if (this.sourceBundle) {
            this.addSourceBundleManifestEntries(mavenArchiveConfiguration);
        }
    }

    private void addSourceBundleManifestEntries(MavenArchiveConfiguration mavenArchiveConfiguration) {
        TychoProject projectType = this.projectTypes.get(this.project.getPackaging());
        ArtifactKey artifactKey = projectType.getArtifactKey(DefaultReactorProject.adapt((MavenProject)this.project));
        String symbolicName = artifactKey.getId();
        String version = artifactKey.getVersion();
        if (symbolicName != null && version != null) {
            mavenArchiveConfiguration.addManifestEntry("Bundle-ManifestVersion", "2");
            mavenArchiveConfiguration.addManifestEntry("Bundle-SymbolicName", symbolicName + this.sourceBundleSuffix);
            Version expandedVersion = this.getExpandedVersion(version);
            mavenArchiveConfiguration.addManifestEntry("Bundle-Version", expandedVersion.toString());
            mavenArchiveConfiguration.addManifestEntry(MANIFEST_HEADER_ECLIPSE_SOURCE_BUNDLE, symbolicName + ";version=\"" + expandedVersion + "\";roots:=\"" + this.getEclipseHeaderSourceRoots() + "\"");
            mavenArchiveConfiguration.addManifestEntry("Bundle-Name", "%bundleName");
            mavenArchiveConfiguration.addManifestEntry("Bundle-Vendor", "%bundleVendor");
            mavenArchiveConfiguration.addManifestEntry("Bundle-Localization", MANIFEST_BUNDLE_LOCALIZATION_BASENAME);
        } else {
            this.getLog().info((CharSequence)"NOT adding source bundle manifest entries. Incomplete or no bundle information available.");
        }
    }

    private String getEclipseHeaderSourceRoots() {
        if (!this.distinctSourceRoots) {
            return ".";
        }
        StringJoiner result = new StringJoiner(",");
        for (String jarName : DefaultReactorProject.adapt((MavenProject)this.project).getBuildProperties().getJarToSourceFolderMap().keySet()) {
            String sourceRoot = ".".equals(jarName) ? "." : OsgiSourceMojo.getSourceRootTargetPath(jarName);
            result.add(sourceRoot);
        }
        return result.toString();
    }

    private static String getSourceRootTargetPath(String jarName) {
        if (jarName.endsWith(".jar")) {
            jarName = jarName.substring(0, jarName.length() - ".jar".length());
        } else if (jarName.endsWith("/")) {
            jarName = jarName.substring(0, jarName.length() - 1);
        }
        return jarName + "src";
    }

    private Version getExpandedVersion(String versionStr) {
        Version version = Version.parseVersion((String)versionStr);
        if (VERSION_QUALIFIER.equals(version.getQualifier())) {
            return new Version(version.getMajor(), version.getMinor(), version.getMicro(), this.qualifier);
        }
        return version;
    }

    @Override
    protected boolean isRelevantProject(MavenProject project) {
        return OsgiSourceMojo.isRelevant(project);
    }

    public static boolean isRelevant(MavenProject project) {
        boolean relevant;
        String packaging = project.getPackaging();
        boolean bl = relevant = "eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging);
        if (!relevant) {
            return false;
        }
        Plugin plugin = project.getPlugin("org.eclipse.tycho:tycho-source-plugin");
        if (plugin == null) {
            return false;
        }
        for (PluginExecution execution : plugin.getExecutions()) {
            boolean hasAdditionalFilesets;
            if (!execution.getGoals().contains(GOAL)) continue;
            boolean requireSourceRoots = Boolean.parseBoolean(OsgiSourceMojo.getParameterValue(execution, "requireSourceRoots", "false"));
            if (requireSourceRoots) {
                return true;
            }
            boolean bl2 = hasAdditionalFilesets = OsgiSourceMojo.getConfigurationElement((Xpp3Dom)execution.getConfiguration(), "additionalFileSets") != null;
            if (hasAdditionalFilesets) {
                return true;
            }
            BuildProperties buildProperties = DefaultReactorProject.adapt((MavenProject)project).getBuildProperties();
            if (buildProperties.getJarToSourceFolderMap().size() <= 0 && buildProperties.getSourceIncludes().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private static String getParameterValue(PluginExecution execution, String name, String defaultValue) {
        String value = OsgiSourceMojo.getElementValue((Xpp3Dom)execution.getConfiguration(), name);
        return value != null ? value : defaultValue;
    }

    private static String getElementValue(Xpp3Dom config, String name) {
        Xpp3Dom child = OsgiSourceMojo.getConfigurationElement(config, name);
        if (child == null) {
            return null;
        }
        return child.getValue();
    }

    private static Xpp3Dom getConfigurationElement(Xpp3Dom config, String name) {
        if (config == null) {
            return null;
        }
        Xpp3Dom child = config.getChild(name);
        return child;
    }
}

