/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.source;

import aQute.bnd.osgi.Jar;
import java.io.File;
import java.util.jar.Attributes;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-pde-source-header", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class PDESourceBundleMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="sourceBundleSuffix", defaultValue=".source")
    private String sourceBundleSuffix;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String packaging = this.project.getPackaging();
        if ("jar".equals(packaging) || "bundle".equals(packaging)) {
            for (Artifact artifact : this.project.getAttachedArtifacts()) {
                if (!"sources".equalsIgnoreCase(artifact.getClassifier()) || !"java-source".equals(artifact.getType())) continue;
                File sourceFile = artifact.getFile();
                try (Jar hostBundle = new Jar(this.project.getArtifact().getFile());
                     Jar sourceJar = new Jar(sourceFile);){
                    Attributes hostMain = hostBundle.getManifest().getMainAttributes();
                    Attributes sourceMain = sourceJar.getManifest().getMainAttributes();
                    String hostName = hostMain.getValue("Bundle-SymbolicName");
                    String hostVersion = hostMain.getValue("Bundle-Version");
                    sourceMain.putValue("Bundle-ManifestVersion", "2");
                    sourceMain.putValue("Bundle-SymbolicName", hostName + this.sourceBundleSuffix);
                    sourceMain.putValue("Bundle-Version", hostVersion);
                    sourceMain.putValue("Eclipse-SourceBundle", hostName + ";version=\"" + hostVersion + "\";roots:=\".\"");
                    String baseName = FilenameUtils.getBaseName((String)sourceFile.getName());
                    File outputFile = new File(sourceFile.getParentFile(), baseName + "-pde.jar");
                    sourceJar.write(outputFile);
                    artifact.setFile(outputFile);
                }
                catch (Exception e) {
                    throw new MojoFailureException("Update of manifest failed!", (Throwable)e);
                }
            }
        }
    }
}

