/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.source;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.p2maven.InstallableUnitProvider;
import org.eclipse.tycho.p2maven.InstallableUnitPublisher;
import org.eclipse.tycho.source.OsgiSourceMojo;
import org.eclipse.tycho.source.SourceFeatureMojo;
import org.eclipse.tycho.source.SourceFeatureP2MetadataProvider;

@Component(role=InstallableUnitProvider.class, hint="source")
public class SourceInstallableUnitProvider
implements InstallableUnitProvider {
    @Requirement
    private InstallableUnitPublisher publisher;
    @Requirement
    private BundleReader bundleReader;
    @Requirement(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;

    public Collection<IInstallableUnit> getInstallableUnits(MavenProject project, MavenSession session) throws CoreException {
        if (SourceFeatureMojo.isEnabledForProject(project)) {
            try {
                File sourceFeatureBasedir = SourceFeatureMojo.getSourcesFeatureOutputDir(project);
                Feature sourceFeature = SourceFeatureP2MetadataProvider.createPreliminarySourceFeature(project);
                File file = new File(sourceFeatureBasedir, "feature.xml");
                Feature.write((Feature)sourceFeature, (File)file);
                FeaturesAction featuresAction = new FeaturesAction(new File[]{sourceFeatureBasedir});
                return this.publisher.publishMetadata(List.of(featuresAction));
            }
            catch (IOException e) {
                throw new CoreException(Status.error((String)"Creating preliminary source feature failed", (Throwable)e));
            }
        }
        if (OsgiSourceMojo.isRelevant(project)) {
            TychoProject projectType = this.projectTypes.get(project.getPackaging());
            ArtifactKey artifactKey = projectType.getArtifactKey(DefaultReactorProject.adapt((MavenProject)project));
            String symbolicName = artifactKey.getId();
            String version = artifactKey.getVersion();
            Hashtable<String, String> manifest = new Hashtable<String, String>();
            ((Dictionary)manifest).put("Manifest-Version", "1.0");
            ((Dictionary)manifest).put("Bundle-ManifestVersion", "2");
            ((Dictionary)manifest).put("Bundle-SymbolicName", String.format("%s.source", symbolicName));
            ((Dictionary)manifest).put("Bundle-Version", version);
            ((Dictionary)manifest).put("Eclipse-SourceBundle", String.format("%s;version=%s;roots:=\".\"", symbolicName, version));
            BundleDescription bundleDescription = BundlesAction.createBundleDescription(manifest, (File)project.getBasedir());
            if (bundleDescription != null) {
                return this.publisher.publishMetadata(List.of(new BundlesAction(new BundleDescription[]{bundleDescription}){

                    protected void createAdviceFileAdvice(BundleDescription bundleDescription, IPublisherInfo publisherInfo) {
                    }
                }));
            }
        }
        return Collections.emptyList();
    }
}

